package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ChangeProjectSettingsProductSearchIndexingEnabled {
  private Boolean enabled;

  public ChangeProjectSettingsProductSearchIndexingEnabled() {
  }

  public ChangeProjectSettingsProductSearchIndexingEnabled(Boolean enabled) {
    this.enabled = enabled;
  }

  public Boolean getEnabled() {
    return enabled;
  }

  public void setEnabled(Boolean enabled) {
    this.enabled = enabled;
  }

  @Override
  public String toString() {
    return "ChangeProjectSettingsProductSearchIndexingEnabled{enabled='" + enabled + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeProjectSettingsProductSearchIndexingEnabled that = (ChangeProjectSettingsProductSearchIndexingEnabled) o;
    return Objects.equals(enabled, that.enabled);
  }

  @Override
  public int hashCode() {
    return Objects.hash(enabled);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Boolean enabled;

    public ChangeProjectSettingsProductSearchIndexingEnabled build() {
      ChangeProjectSettingsProductSearchIndexingEnabled result = new ChangeProjectSettingsProductSearchIndexingEnabled();
      result.enabled = this.enabled;
      return result;
    }

    public Builder enabled(Boolean enabled) {
      this.enabled = enabled;
      return this;
    }
  }
}
