package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ChangeProjectSettingsShoppingListsConfiguration {
  private ShoppingListsConfigurationInput shoppingListsConfiguration;

  public ChangeProjectSettingsShoppingListsConfiguration() {
  }

  public ChangeProjectSettingsShoppingListsConfiguration(
      ShoppingListsConfigurationInput shoppingListsConfiguration) {
    this.shoppingListsConfiguration = shoppingListsConfiguration;
  }

  public ShoppingListsConfigurationInput getShoppingListsConfiguration() {
    return shoppingListsConfiguration;
  }

  public void setShoppingListsConfiguration(
      ShoppingListsConfigurationInput shoppingListsConfiguration) {
    this.shoppingListsConfiguration = shoppingListsConfiguration;
  }

  @Override
  public String toString() {
    return "ChangeProjectSettingsShoppingListsConfiguration{shoppingListsConfiguration='" + shoppingListsConfiguration + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeProjectSettingsShoppingListsConfiguration that = (ChangeProjectSettingsShoppingListsConfiguration) o;
    return Objects.equals(shoppingListsConfiguration, that.shoppingListsConfiguration);
  }

  @Override
  public int hashCode() {
    return Objects.hash(shoppingListsConfiguration);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ShoppingListsConfigurationInput shoppingListsConfiguration;

    public ChangeProjectSettingsShoppingListsConfiguration build() {
      ChangeProjectSettingsShoppingListsConfiguration result = new ChangeProjectSettingsShoppingListsConfiguration();
      result.shoppingListsConfiguration = this.shoppingListsConfiguration;
      return result;
    }

    public Builder shoppingListsConfiguration(
        ShoppingListsConfigurationInput shoppingListsConfiguration) {
      this.shoppingListsConfiguration = shoppingListsConfiguration;
      return this;
    }
  }
}
