package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ChangeQuoteRequestState {
  private QuoteRequestState quoteRequestState;

  public ChangeQuoteRequestState() {
  }

  public ChangeQuoteRequestState(QuoteRequestState quoteRequestState) {
    this.quoteRequestState = quoteRequestState;
  }

  public QuoteRequestState getQuoteRequestState() {
    return quoteRequestState;
  }

  public void setQuoteRequestState(QuoteRequestState quoteRequestState) {
    this.quoteRequestState = quoteRequestState;
  }

  @Override
  public String toString() {
    return "ChangeQuoteRequestState{quoteRequestState='" + quoteRequestState + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeQuoteRequestState that = (ChangeQuoteRequestState) o;
    return Objects.equals(quoteRequestState, that.quoteRequestState);
  }

  @Override
  public int hashCode() {
    return Objects.hash(quoteRequestState);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private QuoteRequestState quoteRequestState;

    public ChangeQuoteRequestState build() {
      ChangeQuoteRequestState result = new ChangeQuoteRequestState();
      result.quoteRequestState = this.quoteRequestState;
      return result;
    }

    public Builder quoteRequestState(QuoteRequestState quoteRequestState) {
      this.quoteRequestState = quoteRequestState;
      return this;
    }
  }
}
