package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ChangeQuoteState {
  private QuoteState quoteState;

  public ChangeQuoteState() {
  }

  public ChangeQuoteState(QuoteState quoteState) {
    this.quoteState = quoteState;
  }

  public QuoteState getQuoteState() {
    return quoteState;
  }

  public void setQuoteState(QuoteState quoteState) {
    this.quoteState = quoteState;
  }

  @Override
  public String toString() {
    return "ChangeQuoteState{quoteState='" + quoteState + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeQuoteState that = (ChangeQuoteState) o;
    return Objects.equals(quoteState, that.quoteState);
  }

  @Override
  public int hashCode() {
    return Objects.hash(quoteState);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private QuoteState quoteState;

    public ChangeQuoteState build() {
      ChangeQuoteState result = new ChangeQuoteState();
      result.quoteState = this.quoteState;
      return result;
    }

    public Builder quoteState(QuoteState quoteState) {
      this.quoteState = quoteState;
      return this;
    }
  }
}
