package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ChangeShippingMethodActive {
  private Boolean active;

  public ChangeShippingMethodActive() {
  }

  public ChangeShippingMethodActive(Boolean active) {
    this.active = active;
  }

  public Boolean getActive() {
    return active;
  }

  public void setActive(Boolean active) {
    this.active = active;
  }

  @Override
  public String toString() {
    return "ChangeShippingMethodActive{active='" + active + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeShippingMethodActive that = (ChangeShippingMethodActive) o;
    return Objects.equals(active, that.active);
  }

  @Override
  public int hashCode() {
    return Objects.hash(active);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Boolean active;

    public ChangeShippingMethodActive build() {
      ChangeShippingMethodActive result = new ChangeShippingMethodActive();
      result.active = this.active;
      return result;
    }

    public Builder active(Boolean active) {
      this.active = active;
      return this;
    }
  }
}
