package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ChangeShippingMethodTaxCategory {
  private ResourceIdentifierInput taxCategory;

  public ChangeShippingMethodTaxCategory() {
  }

  public ChangeShippingMethodTaxCategory(ResourceIdentifierInput taxCategory) {
    this.taxCategory = taxCategory;
  }

  public ResourceIdentifierInput getTaxCategory() {
    return taxCategory;
  }

  public void setTaxCategory(ResourceIdentifierInput taxCategory) {
    this.taxCategory = taxCategory;
  }

  @Override
  public String toString() {
    return "ChangeShippingMethodTaxCategory{taxCategory='" + taxCategory + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeShippingMethodTaxCategory that = (ChangeShippingMethodTaxCategory) o;
    return Objects.equals(taxCategory, that.taxCategory);
  }

  @Override
  public int hashCode() {
    return Objects.hash(taxCategory);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ResourceIdentifierInput taxCategory;

    public ChangeShippingMethodTaxCategory build() {
      ChangeShippingMethodTaxCategory result = new ChangeShippingMethodTaxCategory();
      result.taxCategory = this.taxCategory;
      return result;
    }

    public Builder taxCategory(ResourceIdentifierInput taxCategory) {
      this.taxCategory = taxCategory;
      return this;
    }
  }
}
