package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class ChangeShoppingListTextLineItemName {
  private String textLineItemId;

  private String textLineItemKey;

  private List<LocalizedStringItemInputType> name;

  public ChangeShoppingListTextLineItemName() {
  }

  public ChangeShoppingListTextLineItemName(String textLineItemId, String textLineItemKey,
      List<LocalizedStringItemInputType> name) {
    this.textLineItemId = textLineItemId;
    this.textLineItemKey = textLineItemKey;
    this.name = name;
  }

  public String getTextLineItemId() {
    return textLineItemId;
  }

  public void setTextLineItemId(String textLineItemId) {
    this.textLineItemId = textLineItemId;
  }

  public String getTextLineItemKey() {
    return textLineItemKey;
  }

  public void setTextLineItemKey(String textLineItemKey) {
    this.textLineItemKey = textLineItemKey;
  }

  public List<LocalizedStringItemInputType> getName() {
    return name;
  }

  public void setName(List<LocalizedStringItemInputType> name) {
    this.name = name;
  }

  @Override
  public String toString() {
    return "ChangeShoppingListTextLineItemName{textLineItemId='" + textLineItemId + "', textLineItemKey='" + textLineItemKey + "', name='" + name + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeShoppingListTextLineItemName that = (ChangeShoppingListTextLineItemName) o;
    return Objects.equals(textLineItemId, that.textLineItemId) &&
        Objects.equals(textLineItemKey, that.textLineItemKey) &&
        Objects.equals(name, that.name);
  }

  @Override
  public int hashCode() {
    return Objects.hash(textLineItemId, textLineItemKey, name);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String textLineItemId;

    private String textLineItemKey;

    private List<LocalizedStringItemInputType> name;

    public ChangeShoppingListTextLineItemName build() {
      ChangeShoppingListTextLineItemName result = new ChangeShoppingListTextLineItemName();
      result.textLineItemId = this.textLineItemId;
      result.textLineItemKey = this.textLineItemKey;
      result.name = this.name;
      return result;
    }

    public Builder textLineItemId(String textLineItemId) {
      this.textLineItemId = textLineItemId;
      return this;
    }

    public Builder textLineItemKey(String textLineItemKey) {
      this.textLineItemKey = textLineItemKey;
      return this;
    }

    public Builder name(List<LocalizedStringItemInputType> name) {
      this.name = name;
      return this;
    }
  }
}
