package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ChangeStagedOrderCustomLineItemQuantityOutput implements com.commercetools.graphql.api.types.StagedOrderUpdateActionOutput {
  private String type;

  private String customLineItemId;

  private String customLineItemKey;

  private Long quantity;

  public ChangeStagedOrderCustomLineItemQuantityOutput() {
  }

  public ChangeStagedOrderCustomLineItemQuantityOutput(String type, String customLineItemId,
      String customLineItemKey, Long quantity) {
    this.type = type;
    this.customLineItemId = customLineItemId;
    this.customLineItemKey = customLineItemKey;
    this.quantity = quantity;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public String getCustomLineItemId() {
    return customLineItemId;
  }

  public void setCustomLineItemId(String customLineItemId) {
    this.customLineItemId = customLineItemId;
  }

  public String getCustomLineItemKey() {
    return customLineItemKey;
  }

  public void setCustomLineItemKey(String customLineItemKey) {
    this.customLineItemKey = customLineItemKey;
  }

  public Long getQuantity() {
    return quantity;
  }

  public void setQuantity(Long quantity) {
    this.quantity = quantity;
  }

  @Override
  public String toString() {
    return "ChangeStagedOrderCustomLineItemQuantityOutput{type='" + type + "', customLineItemId='" + customLineItemId + "', customLineItemKey='" + customLineItemKey + "', quantity='" + quantity + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeStagedOrderCustomLineItemQuantityOutput that = (ChangeStagedOrderCustomLineItemQuantityOutput) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(customLineItemId, that.customLineItemId) &&
        Objects.equals(customLineItemKey, that.customLineItemKey) &&
        Objects.equals(quantity, that.quantity);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, customLineItemId, customLineItemKey, quantity);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private String customLineItemId;

    private String customLineItemKey;

    private Long quantity;

    public ChangeStagedOrderCustomLineItemQuantityOutput build() {
      ChangeStagedOrderCustomLineItemQuantityOutput result = new ChangeStagedOrderCustomLineItemQuantityOutput();
      result.type = this.type;
      result.customLineItemId = this.customLineItemId;
      result.customLineItemKey = this.customLineItemKey;
      result.quantity = this.quantity;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder customLineItemId(String customLineItemId) {
      this.customLineItemId = customLineItemId;
      return this;
    }

    public Builder customLineItemKey(String customLineItemKey) {
      this.customLineItemKey = customLineItemKey;
      return this;
    }

    public Builder quantity(Long quantity) {
      this.quantity = quantity;
      return this;
    }
  }
}
