package com.commercetools.graphql.api.types;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ChangeStagedOrderLineItemQuantity {
  private String lineItemId;

  private Long quantity;

  private String lineItemKey;

  private BaseMoneyInput externalPrice;

  private ExternalLineItemTotalPriceDraft externalTotalPrice;

  public ChangeStagedOrderLineItemQuantity() {
  }

  public ChangeStagedOrderLineItemQuantity(String lineItemId, Long quantity, String lineItemKey,
      BaseMoneyInput externalPrice, ExternalLineItemTotalPriceDraft externalTotalPrice) {
    this.lineItemId = lineItemId;
    this.quantity = quantity;
    this.lineItemKey = lineItemKey;
    this.externalPrice = externalPrice;
    this.externalTotalPrice = externalTotalPrice;
  }

  public String getLineItemId() {
    return lineItemId;
  }

  public void setLineItemId(String lineItemId) {
    this.lineItemId = lineItemId;
  }

  public Long getQuantity() {
    return quantity;
  }

  public void setQuantity(Long quantity) {
    this.quantity = quantity;
  }

  public String getLineItemKey() {
    return lineItemKey;
  }

  public void setLineItemKey(String lineItemKey) {
    this.lineItemKey = lineItemKey;
  }

  public BaseMoneyInput getExternalPrice() {
    return externalPrice;
  }

  public void setExternalPrice(BaseMoneyInput externalPrice) {
    this.externalPrice = externalPrice;
  }

  public ExternalLineItemTotalPriceDraft getExternalTotalPrice() {
    return externalTotalPrice;
  }

  public void setExternalTotalPrice(ExternalLineItemTotalPriceDraft externalTotalPrice) {
    this.externalTotalPrice = externalTotalPrice;
  }

  @Override
  public String toString() {
    return "ChangeStagedOrderLineItemQuantity{lineItemId='" + lineItemId + "', quantity='" + quantity + "', lineItemKey='" + lineItemKey + "', externalPrice='" + externalPrice + "', externalTotalPrice='" + externalTotalPrice + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeStagedOrderLineItemQuantity that = (ChangeStagedOrderLineItemQuantity) o;
    return Objects.equals(lineItemId, that.lineItemId) &&
        Objects.equals(quantity, that.quantity) &&
        Objects.equals(lineItemKey, that.lineItemKey) &&
        Objects.equals(externalPrice, that.externalPrice) &&
        Objects.equals(externalTotalPrice, that.externalTotalPrice);
  }

  @Override
  public int hashCode() {
    return Objects.hash(lineItemId, quantity, lineItemKey, externalPrice, externalTotalPrice);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String lineItemId;

    private Long quantity;

    private String lineItemKey;

    private BaseMoneyInput externalPrice;

    private ExternalLineItemTotalPriceDraft externalTotalPrice;

    public ChangeStagedOrderLineItemQuantity build() {
      ChangeStagedOrderLineItemQuantity result = new ChangeStagedOrderLineItemQuantity();
      result.lineItemId = this.lineItemId;
      result.quantity = this.quantity;
      result.lineItemKey = this.lineItemKey;
      result.externalPrice = this.externalPrice;
      result.externalTotalPrice = this.externalTotalPrice;
      return result;
    }

    public Builder lineItemId(String lineItemId) {
      this.lineItemId = lineItemId;
      return this;
    }

    public Builder quantity(Long quantity) {
      this.quantity = quantity;
      return this;
    }

    public Builder lineItemKey(String lineItemKey) {
      this.lineItemKey = lineItemKey;
      return this;
    }

    public Builder externalPrice(BaseMoneyInput externalPrice) {
      this.externalPrice = externalPrice;
      return this;
    }

    public Builder externalTotalPrice(ExternalLineItemTotalPriceDraft externalTotalPrice) {
      this.externalTotalPrice = externalTotalPrice;
      return this;
    }
  }
}
