package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ChangeStagedOrderPaymentState {
  private PaymentState paymentState;

  public ChangeStagedOrderPaymentState() {
  }

  public ChangeStagedOrderPaymentState(PaymentState paymentState) {
    this.paymentState = paymentState;
  }

  public PaymentState getPaymentState() {
    return paymentState;
  }

  public void setPaymentState(PaymentState paymentState) {
    this.paymentState = paymentState;
  }

  @Override
  public String toString() {
    return "ChangeStagedOrderPaymentState{paymentState='" + paymentState + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeStagedOrderPaymentState that = (ChangeStagedOrderPaymentState) o;
    return Objects.equals(paymentState, that.paymentState);
  }

  @Override
  public int hashCode() {
    return Objects.hash(paymentState);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private PaymentState paymentState;

    public ChangeStagedOrderPaymentState build() {
      ChangeStagedOrderPaymentState result = new ChangeStagedOrderPaymentState();
      result.paymentState = this.paymentState;
      return result;
    }

    public Builder paymentState(PaymentState paymentState) {
      this.paymentState = paymentState;
      return this;
    }
  }
}
