package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ChangeStagedOrderPaymentStateOutput implements com.commercetools.graphql.api.types.StagedOrderUpdateActionOutput {
  private String type;

  private PaymentState paymentState;

  public ChangeStagedOrderPaymentStateOutput() {
  }

  public ChangeStagedOrderPaymentStateOutput(String type, PaymentState paymentState) {
    this.type = type;
    this.paymentState = paymentState;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public PaymentState getPaymentState() {
    return paymentState;
  }

  public void setPaymentState(PaymentState paymentState) {
    this.paymentState = paymentState;
  }

  @Override
  public String toString() {
    return "ChangeStagedOrderPaymentStateOutput{type='" + type + "', paymentState='" + paymentState + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeStagedOrderPaymentStateOutput that = (ChangeStagedOrderPaymentStateOutput) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(paymentState, that.paymentState);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, paymentState);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private PaymentState paymentState;

    public ChangeStagedOrderPaymentStateOutput build() {
      ChangeStagedOrderPaymentStateOutput result = new ChangeStagedOrderPaymentStateOutput();
      result.type = this.type;
      result.paymentState = this.paymentState;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder paymentState(PaymentState paymentState) {
      this.paymentState = paymentState;
      return this;
    }
  }
}
