package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ChangeStagedOrderTaxCalculationMode {
  private TaxCalculationMode taxCalculationMode;

  public ChangeStagedOrderTaxCalculationMode() {
  }

  public ChangeStagedOrderTaxCalculationMode(TaxCalculationMode taxCalculationMode) {
    this.taxCalculationMode = taxCalculationMode;
  }

  public TaxCalculationMode getTaxCalculationMode() {
    return taxCalculationMode;
  }

  public void setTaxCalculationMode(TaxCalculationMode taxCalculationMode) {
    this.taxCalculationMode = taxCalculationMode;
  }

  @Override
  public String toString() {
    return "ChangeStagedOrderTaxCalculationMode{taxCalculationMode='" + taxCalculationMode + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeStagedOrderTaxCalculationMode that = (ChangeStagedOrderTaxCalculationMode) o;
    return Objects.equals(taxCalculationMode, that.taxCalculationMode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(taxCalculationMode);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private TaxCalculationMode taxCalculationMode;

    public ChangeStagedOrderTaxCalculationMode build() {
      ChangeStagedOrderTaxCalculationMode result = new ChangeStagedOrderTaxCalculationMode();
      result.taxCalculationMode = this.taxCalculationMode;
      return result;
    }

    public Builder taxCalculationMode(TaxCalculationMode taxCalculationMode) {
      this.taxCalculationMode = taxCalculationMode;
      return this;
    }
  }
}
