package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ChangeStagedOrderTaxCalculationModeOutput implements com.commercetools.graphql.api.types.StagedOrderUpdateActionOutput {
  private String type;

  private TaxCalculationMode taxCalculationMode;

  public ChangeStagedOrderTaxCalculationModeOutput() {
  }

  public ChangeStagedOrderTaxCalculationModeOutput(String type,
      TaxCalculationMode taxCalculationMode) {
    this.type = type;
    this.taxCalculationMode = taxCalculationMode;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public TaxCalculationMode getTaxCalculationMode() {
    return taxCalculationMode;
  }

  public void setTaxCalculationMode(TaxCalculationMode taxCalculationMode) {
    this.taxCalculationMode = taxCalculationMode;
  }

  @Override
  public String toString() {
    return "ChangeStagedOrderTaxCalculationModeOutput{type='" + type + "', taxCalculationMode='" + taxCalculationMode + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeStagedOrderTaxCalculationModeOutput that = (ChangeStagedOrderTaxCalculationModeOutput) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(taxCalculationMode, that.taxCalculationMode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, taxCalculationMode);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private TaxCalculationMode taxCalculationMode;

    public ChangeStagedOrderTaxCalculationModeOutput build() {
      ChangeStagedOrderTaxCalculationModeOutput result = new ChangeStagedOrderTaxCalculationModeOutput();
      result.type = this.type;
      result.taxCalculationMode = this.taxCalculationMode;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder taxCalculationMode(TaxCalculationMode taxCalculationMode) {
      this.taxCalculationMode = taxCalculationMode;
      return this;
    }
  }
}
