package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ChangeStagedOrderTaxModeOutput implements com.commercetools.graphql.api.types.StagedOrderUpdateActionOutput {
  private String type;

  private TaxMode taxMode;

  public ChangeStagedOrderTaxModeOutput() {
  }

  public ChangeStagedOrderTaxModeOutput(String type, TaxMode taxMode) {
    this.type = type;
    this.taxMode = taxMode;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public TaxMode getTaxMode() {
    return taxMode;
  }

  public void setTaxMode(TaxMode taxMode) {
    this.taxMode = taxMode;
  }

  @Override
  public String toString() {
    return "ChangeStagedOrderTaxModeOutput{type='" + type + "', taxMode='" + taxMode + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeStagedOrderTaxModeOutput that = (ChangeStagedOrderTaxModeOutput) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(taxMode, that.taxMode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, taxMode);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private TaxMode taxMode;

    public ChangeStagedOrderTaxModeOutput build() {
      ChangeStagedOrderTaxModeOutput result = new ChangeStagedOrderTaxModeOutput();
      result.type = this.type;
      result.taxMode = this.taxMode;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder taxMode(TaxMode taxMode) {
      this.taxMode = taxMode;
      return this;
    }
  }
}
