package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ChangeStagedOrderTaxRoundingModeOutput implements com.commercetools.graphql.api.types.StagedOrderUpdateActionOutput {
  private String type;

  private RoundingMode taxRoundingMode;

  public ChangeStagedOrderTaxRoundingModeOutput() {
  }

  public ChangeStagedOrderTaxRoundingModeOutput(String type, RoundingMode taxRoundingMode) {
    this.type = type;
    this.taxRoundingMode = taxRoundingMode;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public RoundingMode getTaxRoundingMode() {
    return taxRoundingMode;
  }

  public void setTaxRoundingMode(RoundingMode taxRoundingMode) {
    this.taxRoundingMode = taxRoundingMode;
  }

  @Override
  public String toString() {
    return "ChangeStagedOrderTaxRoundingModeOutput{type='" + type + "', taxRoundingMode='" + taxRoundingMode + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeStagedOrderTaxRoundingModeOutput that = (ChangeStagedOrderTaxRoundingModeOutput) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(taxRoundingMode, that.taxRoundingMode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, taxRoundingMode);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private RoundingMode taxRoundingMode;

    public ChangeStagedOrderTaxRoundingModeOutput build() {
      ChangeStagedOrderTaxRoundingModeOutput result = new ChangeStagedOrderTaxRoundingModeOutput();
      result.type = this.type;
      result.taxRoundingMode = this.taxRoundingMode;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder taxRoundingMode(RoundingMode taxRoundingMode) {
      this.taxRoundingMode = taxRoundingMode;
      return this;
    }
  }
}
