package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ChangeStandalonePriceValue {
  private BaseMoneyInput value;

  /**
   * default is `false`
   */
  private Boolean staged;

  public ChangeStandalonePriceValue() {
  }

  public ChangeStandalonePriceValue(BaseMoneyInput value, Boolean staged) {
    this.value = value;
    this.staged = staged;
  }

  public BaseMoneyInput getValue() {
    return value;
  }

  public void setValue(BaseMoneyInput value) {
    this.value = value;
  }

  /**
   * default is `false`
   */
  public Boolean getStaged() {
    return staged;
  }

  public void setStaged(Boolean staged) {
    this.staged = staged;
  }

  @Override
  public String toString() {
    return "ChangeStandalonePriceValue{value='" + value + "', staged='" + staged + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeStandalonePriceValue that = (ChangeStandalonePriceValue) o;
    return Objects.equals(value, that.value) &&
        Objects.equals(staged, that.staged);
  }

  @Override
  public int hashCode() {
    return Objects.hash(value, staged);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private BaseMoneyInput value;

    /**
     * default is `false`
     */
    private Boolean staged;

    public ChangeStandalonePriceValue build() {
      ChangeStandalonePriceValue result = new ChangeStandalonePriceValue();
      result.value = this.value;
      result.staged = this.staged;
      return result;
    }

    public Builder value(BaseMoneyInput value) {
      this.value = value;
      return this;
    }

    /**
     * default is `false`
     */
    public Builder staged(Boolean staged) {
      this.staged = staged;
      return this;
    }
  }
}
