package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ChangeStateInitial {
  private Boolean initial;

  public ChangeStateInitial() {
  }

  public ChangeStateInitial(Boolean initial) {
    this.initial = initial;
  }

  public Boolean getInitial() {
    return initial;
  }

  public void setInitial(Boolean initial) {
    this.initial = initial;
  }

  @Override
  public String toString() {
    return "ChangeStateInitial{initial='" + initial + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeStateInitial that = (ChangeStateInitial) o;
    return Objects.equals(initial, that.initial);
  }

  @Override
  public int hashCode() {
    return Objects.hash(initial);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Boolean initial;

    public ChangeStateInitial build() {
      ChangeStateInitial result = new ChangeStateInitial();
      result.initial = this.initial;
      return result;
    }

    public Builder initial(Boolean initial) {
      this.initial = initial;
      return this;
    }
  }
}
