package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ChangeTypeInputHint {
  private String fieldName;

  private TextInputHint inputHint;

  public ChangeTypeInputHint() {
  }

  public ChangeTypeInputHint(String fieldName, TextInputHint inputHint) {
    this.fieldName = fieldName;
    this.inputHint = inputHint;
  }

  public String getFieldName() {
    return fieldName;
  }

  public void setFieldName(String fieldName) {
    this.fieldName = fieldName;
  }

  public TextInputHint getInputHint() {
    return inputHint;
  }

  public void setInputHint(TextInputHint inputHint) {
    this.inputHint = inputHint;
  }

  @Override
  public String toString() {
    return "ChangeTypeInputHint{fieldName='" + fieldName + "', inputHint='" + inputHint + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeTypeInputHint that = (ChangeTypeInputHint) o;
    return Objects.equals(fieldName, that.fieldName) &&
        Objects.equals(inputHint, that.inputHint);
  }

  @Override
  public int hashCode() {
    return Objects.hash(fieldName, inputHint);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String fieldName;

    private TextInputHint inputHint;

    public ChangeTypeInputHint build() {
      ChangeTypeInputHint result = new ChangeTypeInputHint();
      result.fieldName = this.fieldName;
      result.inputHint = this.inputHint;
      return result;
    }

    public Builder fieldName(String fieldName) {
      this.fieldName = fieldName;
      return this;
    }

    public Builder inputHint(TextInputHint inputHint) {
      this.inputHint = inputHint;
      return this;
    }
  }
}
