package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class Channel implements com.commercetools.graphql.api.types.Versioned, com.commercetools.graphql.api.types.ReviewTarget, com.commercetools.graphql.api.types.ReferenceExpandable {
  private String id;

  private Long version;

  private String key;

  private List<ChannelRole> roles;

  private String name;

  private List<LocalizedString> nameAllLocales;

  private String description;

  private List<LocalizedString> descriptionAllLocales;

  private Address address;

  private Geometry geoLocation;

  private OffsetDateTime createdAt;

  private OffsetDateTime lastModifiedAt;

  private ReviewRatingStatistics reviewRatingStatistics;

  private CustomFieldsType custom;

  private Initiator createdBy;

  private Initiator lastModifiedBy;

  public Channel() {
  }

  public Channel(String id, Long version, String key, List<ChannelRole> roles, String name,
      List<LocalizedString> nameAllLocales, String description,
      List<LocalizedString> descriptionAllLocales, Address address, Geometry geoLocation,
      OffsetDateTime createdAt, OffsetDateTime lastModifiedAt,
      ReviewRatingStatistics reviewRatingStatistics, CustomFieldsType custom, Initiator createdBy,
      Initiator lastModifiedBy) {
    this.id = id;
    this.version = version;
    this.key = key;
    this.roles = roles;
    this.name = name;
    this.nameAllLocales = nameAllLocales;
    this.description = description;
    this.descriptionAllLocales = descriptionAllLocales;
    this.address = address;
    this.geoLocation = geoLocation;
    this.createdAt = createdAt;
    this.lastModifiedAt = lastModifiedAt;
    this.reviewRatingStatistics = reviewRatingStatistics;
    this.custom = custom;
    this.createdBy = createdBy;
    this.lastModifiedBy = lastModifiedBy;
  }

  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public Long getVersion() {
    return version;
  }

  public void setVersion(Long version) {
    this.version = version;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public List<ChannelRole> getRoles() {
    return roles;
  }

  public void setRoles(List<ChannelRole> roles) {
    this.roles = roles;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public List<LocalizedString> getNameAllLocales() {
    return nameAllLocales;
  }

  public void setNameAllLocales(List<LocalizedString> nameAllLocales) {
    this.nameAllLocales = nameAllLocales;
  }

  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public List<LocalizedString> getDescriptionAllLocales() {
    return descriptionAllLocales;
  }

  public void setDescriptionAllLocales(List<LocalizedString> descriptionAllLocales) {
    this.descriptionAllLocales = descriptionAllLocales;
  }

  public Address getAddress() {
    return address;
  }

  public void setAddress(Address address) {
    this.address = address;
  }

  public Geometry getGeoLocation() {
    return geoLocation;
  }

  public void setGeoLocation(Geometry geoLocation) {
    this.geoLocation = geoLocation;
  }

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }

  public OffsetDateTime getLastModifiedAt() {
    return lastModifiedAt;
  }

  public void setLastModifiedAt(OffsetDateTime lastModifiedAt) {
    this.lastModifiedAt = lastModifiedAt;
  }

  public ReviewRatingStatistics getReviewRatingStatistics() {
    return reviewRatingStatistics;
  }

  public void setReviewRatingStatistics(ReviewRatingStatistics reviewRatingStatistics) {
    this.reviewRatingStatistics = reviewRatingStatistics;
  }

  public CustomFieldsType getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsType custom) {
    this.custom = custom;
  }

  public Initiator getCreatedBy() {
    return createdBy;
  }

  public void setCreatedBy(Initiator createdBy) {
    this.createdBy = createdBy;
  }

  public Initiator getLastModifiedBy() {
    return lastModifiedBy;
  }

  public void setLastModifiedBy(Initiator lastModifiedBy) {
    this.lastModifiedBy = lastModifiedBy;
  }

  @Override
  public String toString() {
    return "Channel{id='" + id + "', version='" + version + "', key='" + key + "', roles='" + roles + "', name='" + name + "', nameAllLocales='" + nameAllLocales + "', description='" + description + "', descriptionAllLocales='" + descriptionAllLocales + "', address='" + address + "', geoLocation='" + geoLocation + "', createdAt='" + createdAt + "', lastModifiedAt='" + lastModifiedAt + "', reviewRatingStatistics='" + reviewRatingStatistics + "', custom='" + custom + "', createdBy='" + createdBy + "', lastModifiedBy='" + lastModifiedBy + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Channel that = (Channel) o;
    return Objects.equals(id, that.id) &&
        Objects.equals(version, that.version) &&
        Objects.equals(key, that.key) &&
        Objects.equals(roles, that.roles) &&
        Objects.equals(name, that.name) &&
        Objects.equals(nameAllLocales, that.nameAllLocales) &&
        Objects.equals(description, that.description) &&
        Objects.equals(descriptionAllLocales, that.descriptionAllLocales) &&
        Objects.equals(address, that.address) &&
        Objects.equals(geoLocation, that.geoLocation) &&
        Objects.equals(createdAt, that.createdAt) &&
        Objects.equals(lastModifiedAt, that.lastModifiedAt) &&
        Objects.equals(reviewRatingStatistics, that.reviewRatingStatistics) &&
        Objects.equals(custom, that.custom) &&
        Objects.equals(createdBy, that.createdBy) &&
        Objects.equals(lastModifiedBy, that.lastModifiedBy);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, version, key, roles, name, nameAllLocales, description, descriptionAllLocales, address, geoLocation, createdAt, lastModifiedAt, reviewRatingStatistics, custom, createdBy, lastModifiedBy);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String id;

    private Long version;

    private String key;

    private List<ChannelRole> roles;

    private String name;

    private List<LocalizedString> nameAllLocales;

    private String description;

    private List<LocalizedString> descriptionAllLocales;

    private Address address;

    private Geometry geoLocation;

    private OffsetDateTime createdAt;

    private OffsetDateTime lastModifiedAt;

    private ReviewRatingStatistics reviewRatingStatistics;

    private CustomFieldsType custom;

    private Initiator createdBy;

    private Initiator lastModifiedBy;

    public Channel build() {
      Channel result = new Channel();
      result.id = this.id;
      result.version = this.version;
      result.key = this.key;
      result.roles = this.roles;
      result.name = this.name;
      result.nameAllLocales = this.nameAllLocales;
      result.description = this.description;
      result.descriptionAllLocales = this.descriptionAllLocales;
      result.address = this.address;
      result.geoLocation = this.geoLocation;
      result.createdAt = this.createdAt;
      result.lastModifiedAt = this.lastModifiedAt;
      result.reviewRatingStatistics = this.reviewRatingStatistics;
      result.custom = this.custom;
      result.createdBy = this.createdBy;
      result.lastModifiedBy = this.lastModifiedBy;
      return result;
    }

    public Builder id(String id) {
      this.id = id;
      return this;
    }

    public Builder version(Long version) {
      this.version = version;
      return this;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder roles(List<ChannelRole> roles) {
      this.roles = roles;
      return this;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }

    public Builder nameAllLocales(List<LocalizedString> nameAllLocales) {
      this.nameAllLocales = nameAllLocales;
      return this;
    }

    public Builder description(String description) {
      this.description = description;
      return this;
    }

    public Builder descriptionAllLocales(List<LocalizedString> descriptionAllLocales) {
      this.descriptionAllLocales = descriptionAllLocales;
      return this;
    }

    public Builder address(Address address) {
      this.address = address;
      return this;
    }

    public Builder geoLocation(Geometry geoLocation) {
      this.geoLocation = geoLocation;
      return this;
    }

    public Builder createdAt(OffsetDateTime createdAt) {
      this.createdAt = createdAt;
      return this;
    }

    public Builder lastModifiedAt(OffsetDateTime lastModifiedAt) {
      this.lastModifiedAt = lastModifiedAt;
      return this;
    }

    public Builder reviewRatingStatistics(ReviewRatingStatistics reviewRatingStatistics) {
      this.reviewRatingStatistics = reviewRatingStatistics;
      return this;
    }

    public Builder custom(CustomFieldsType custom) {
      this.custom = custom;
      return this;
    }

    public Builder createdBy(Initiator createdBy) {
      this.createdBy = createdBy;
      return this;
    }

    public Builder lastModifiedBy(Initiator lastModifiedBy) {
      this.lastModifiedBy = lastModifiedBy;
      return this;
    }
  }
}
