package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class ChannelDraft {
  private String key;

  private List<ChannelRole> roles;

  private List<LocalizedStringItemInputType> name;

  private List<LocalizedStringItemInputType> description;

  private CustomFieldsDraft custom;

  private AddressInput address;

  private GeometryInput geoLocation;

  public ChannelDraft() {
  }

  public ChannelDraft(String key, List<ChannelRole> roles, List<LocalizedStringItemInputType> name,
      List<LocalizedStringItemInputType> description, CustomFieldsDraft custom,
      AddressInput address, GeometryInput geoLocation) {
    this.key = key;
    this.roles = roles;
    this.name = name;
    this.description = description;
    this.custom = custom;
    this.address = address;
    this.geoLocation = geoLocation;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public List<ChannelRole> getRoles() {
    return roles;
  }

  public void setRoles(List<ChannelRole> roles) {
    this.roles = roles;
  }

  public List<LocalizedStringItemInputType> getName() {
    return name;
  }

  public void setName(List<LocalizedStringItemInputType> name) {
    this.name = name;
  }

  public List<LocalizedStringItemInputType> getDescription() {
    return description;
  }

  public void setDescription(List<LocalizedStringItemInputType> description) {
    this.description = description;
  }

  public CustomFieldsDraft getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsDraft custom) {
    this.custom = custom;
  }

  public AddressInput getAddress() {
    return address;
  }

  public void setAddress(AddressInput address) {
    this.address = address;
  }

  public GeometryInput getGeoLocation() {
    return geoLocation;
  }

  public void setGeoLocation(GeometryInput geoLocation) {
    this.geoLocation = geoLocation;
  }

  @Override
  public String toString() {
    return "ChannelDraft{key='" + key + "', roles='" + roles + "', name='" + name + "', description='" + description + "', custom='" + custom + "', address='" + address + "', geoLocation='" + geoLocation + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChannelDraft that = (ChannelDraft) o;
    return Objects.equals(key, that.key) &&
        Objects.equals(roles, that.roles) &&
        Objects.equals(name, that.name) &&
        Objects.equals(description, that.description) &&
        Objects.equals(custom, that.custom) &&
        Objects.equals(address, that.address) &&
        Objects.equals(geoLocation, that.geoLocation);
  }

  @Override
  public int hashCode() {
    return Objects.hash(key, roles, name, description, custom, address, geoLocation);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String key;

    private List<ChannelRole> roles;

    private List<LocalizedStringItemInputType> name;

    private List<LocalizedStringItemInputType> description;

    private CustomFieldsDraft custom;

    private AddressInput address;

    private GeometryInput geoLocation;

    public ChannelDraft build() {
      ChannelDraft result = new ChannelDraft();
      result.key = this.key;
      result.roles = this.roles;
      result.name = this.name;
      result.description = this.description;
      result.custom = this.custom;
      result.address = this.address;
      result.geoLocation = this.geoLocation;
      return result;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder roles(List<ChannelRole> roles) {
      this.roles = roles;
      return this;
    }

    public Builder name(List<LocalizedStringItemInputType> name) {
      this.name = name;
      return this;
    }

    public Builder description(List<LocalizedStringItemInputType> description) {
      this.description = description;
      return this;
    }

    public Builder custom(CustomFieldsDraft custom) {
      this.custom = custom;
      return this;
    }

    public Builder address(AddressInput address) {
      this.address = address;
      return this;
    }

    public Builder geoLocation(GeometryInput geoLocation) {
      this.geoLocation = geoLocation;
      return this;
    }
  }
}
