package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ConfluentCloudDestination implements com.commercetools.graphql.api.types.Destination {
  private String bootstrapServer;

  private String apiKey;

  private String apiSecret;

  private String acks;

  private String topic;

  private String key;

  private String type;

  public ConfluentCloudDestination() {
  }

  public ConfluentCloudDestination(String bootstrapServer, String apiKey, String apiSecret,
      String acks, String topic, String key, String type) {
    this.bootstrapServer = bootstrapServer;
    this.apiKey = apiKey;
    this.apiSecret = apiSecret;
    this.acks = acks;
    this.topic = topic;
    this.key = key;
    this.type = type;
  }

  public String getBootstrapServer() {
    return bootstrapServer;
  }

  public void setBootstrapServer(String bootstrapServer) {
    this.bootstrapServer = bootstrapServer;
  }

  public String getApiKey() {
    return apiKey;
  }

  public void setApiKey(String apiKey) {
    this.apiKey = apiKey;
  }

  public String getApiSecret() {
    return apiSecret;
  }

  public void setApiSecret(String apiSecret) {
    this.apiSecret = apiSecret;
  }

  public String getAcks() {
    return acks;
  }

  public void setAcks(String acks) {
    this.acks = acks;
  }

  public String getTopic() {
    return topic;
  }

  public void setTopic(String topic) {
    this.topic = topic;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "ConfluentCloudDestination{bootstrapServer='" + bootstrapServer + "', apiKey='" + apiKey + "', apiSecret='" + apiSecret + "', acks='" + acks + "', topic='" + topic + "', key='" + key + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ConfluentCloudDestination that = (ConfluentCloudDestination) o;
    return Objects.equals(bootstrapServer, that.bootstrapServer) &&
        Objects.equals(apiKey, that.apiKey) &&
        Objects.equals(apiSecret, that.apiSecret) &&
        Objects.equals(acks, that.acks) &&
        Objects.equals(topic, that.topic) &&
        Objects.equals(key, that.key) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(bootstrapServer, apiKey, apiSecret, acks, topic, key, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String bootstrapServer;

    private String apiKey;

    private String apiSecret;

    private String acks;

    private String topic;

    private String key;

    private String type;

    public ConfluentCloudDestination build() {
      ConfluentCloudDestination result = new ConfluentCloudDestination();
      result.bootstrapServer = this.bootstrapServer;
      result.apiKey = this.apiKey;
      result.apiSecret = this.apiSecret;
      result.acks = this.acks;
      result.topic = this.topic;
      result.key = this.key;
      result.type = this.type;
      return result;
    }

    public Builder bootstrapServer(String bootstrapServer) {
      this.bootstrapServer = bootstrapServer;
      return this;
    }

    public Builder apiKey(String apiKey) {
      this.apiKey = apiKey;
      return this;
    }

    public Builder apiSecret(String apiSecret) {
      this.apiSecret = apiSecret;
      return this;
    }

    public Builder acks(String acks) {
      this.acks = acks;
      return this;
    }

    public Builder topic(String topic) {
      this.topic = topic;
      return this;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
