package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class CountOnCustomLineItemUnits implements com.commercetools.graphql.api.types.PatternComponent {
  private String predicate;

  private Integer minCount;

  private Integer maxCount;

  private Integer excludeCount;

  private String type;

  public CountOnCustomLineItemUnits() {
  }

  public CountOnCustomLineItemUnits(String predicate, Integer minCount, Integer maxCount,
      Integer excludeCount, String type) {
    this.predicate = predicate;
    this.minCount = minCount;
    this.maxCount = maxCount;
    this.excludeCount = excludeCount;
    this.type = type;
  }

  public String getPredicate() {
    return predicate;
  }

  public void setPredicate(String predicate) {
    this.predicate = predicate;
  }

  public Integer getMinCount() {
    return minCount;
  }

  public void setMinCount(Integer minCount) {
    this.minCount = minCount;
  }

  public Integer getMaxCount() {
    return maxCount;
  }

  public void setMaxCount(Integer maxCount) {
    this.maxCount = maxCount;
  }

  public Integer getExcludeCount() {
    return excludeCount;
  }

  public void setExcludeCount(Integer excludeCount) {
    this.excludeCount = excludeCount;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "CountOnCustomLineItemUnits{predicate='" + predicate + "', minCount='" + minCount + "', maxCount='" + maxCount + "', excludeCount='" + excludeCount + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CountOnCustomLineItemUnits that = (CountOnCustomLineItemUnits) o;
    return Objects.equals(predicate, that.predicate) &&
        Objects.equals(minCount, that.minCount) &&
        Objects.equals(maxCount, that.maxCount) &&
        Objects.equals(excludeCount, that.excludeCount) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(predicate, minCount, maxCount, excludeCount, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String predicate;

    private Integer minCount;

    private Integer maxCount;

    private Integer excludeCount;

    private String type;

    public CountOnCustomLineItemUnits build() {
      CountOnCustomLineItemUnits result = new CountOnCustomLineItemUnits();
      result.predicate = this.predicate;
      result.minCount = this.minCount;
      result.maxCount = this.maxCount;
      result.excludeCount = this.excludeCount;
      result.type = this.type;
      return result;
    }

    public Builder predicate(String predicate) {
      this.predicate = predicate;
      return this;
    }

    public Builder minCount(Integer minCount) {
      this.minCount = minCount;
      return this;
    }

    public Builder maxCount(Integer maxCount) {
      this.maxCount = maxCount;
      return this;
    }

    public Builder excludeCount(Integer excludeCount) {
      this.excludeCount = excludeCount;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
