package com.commercetools.graphql.api.types;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class CreateApiClient {
  private String name;

  private String scope;

  private Integer deleteDaysAfterCreation;

  private Integer accessTokenValiditySeconds;

  private Integer refreshTokenValiditySeconds;

  public CreateApiClient() {
  }

  public CreateApiClient(String name, String scope, Integer deleteDaysAfterCreation,
      Integer accessTokenValiditySeconds, Integer refreshTokenValiditySeconds) {
    this.name = name;
    this.scope = scope;
    this.deleteDaysAfterCreation = deleteDaysAfterCreation;
    this.accessTokenValiditySeconds = accessTokenValiditySeconds;
    this.refreshTokenValiditySeconds = refreshTokenValiditySeconds;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getScope() {
    return scope;
  }

  public void setScope(String scope) {
    this.scope = scope;
  }

  public Integer getDeleteDaysAfterCreation() {
    return deleteDaysAfterCreation;
  }

  public void setDeleteDaysAfterCreation(Integer deleteDaysAfterCreation) {
    this.deleteDaysAfterCreation = deleteDaysAfterCreation;
  }

  public Integer getAccessTokenValiditySeconds() {
    return accessTokenValiditySeconds;
  }

  public void setAccessTokenValiditySeconds(Integer accessTokenValiditySeconds) {
    this.accessTokenValiditySeconds = accessTokenValiditySeconds;
  }

  public Integer getRefreshTokenValiditySeconds() {
    return refreshTokenValiditySeconds;
  }

  public void setRefreshTokenValiditySeconds(Integer refreshTokenValiditySeconds) {
    this.refreshTokenValiditySeconds = refreshTokenValiditySeconds;
  }

  @Override
  public String toString() {
    return "CreateApiClient{name='" + name + "', scope='" + scope + "', deleteDaysAfterCreation='" + deleteDaysAfterCreation + "', accessTokenValiditySeconds='" + accessTokenValiditySeconds + "', refreshTokenValiditySeconds='" + refreshTokenValiditySeconds + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CreateApiClient that = (CreateApiClient) o;
    return Objects.equals(name, that.name) &&
        Objects.equals(scope, that.scope) &&
        Objects.equals(deleteDaysAfterCreation, that.deleteDaysAfterCreation) &&
        Objects.equals(accessTokenValiditySeconds, that.accessTokenValiditySeconds) &&
        Objects.equals(refreshTokenValiditySeconds, that.refreshTokenValiditySeconds);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, scope, deleteDaysAfterCreation, accessTokenValiditySeconds, refreshTokenValiditySeconds);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String name;

    private String scope;

    private Integer deleteDaysAfterCreation;

    private Integer accessTokenValiditySeconds;

    private Integer refreshTokenValiditySeconds;

    public CreateApiClient build() {
      CreateApiClient result = new CreateApiClient();
      result.name = this.name;
      result.scope = this.scope;
      result.deleteDaysAfterCreation = this.deleteDaysAfterCreation;
      result.accessTokenValiditySeconds = this.accessTokenValiditySeconds;
      result.refreshTokenValiditySeconds = this.refreshTokenValiditySeconds;
      return result;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }

    public Builder scope(String scope) {
      this.scope = scope;
      return this;
    }

    public Builder deleteDaysAfterCreation(Integer deleteDaysAfterCreation) {
      this.deleteDaysAfterCreation = deleteDaysAfterCreation;
      return this;
    }

    public Builder accessTokenValiditySeconds(Integer accessTokenValiditySeconds) {
      this.accessTokenValiditySeconds = accessTokenValiditySeconds;
      return this;
    }

    public Builder refreshTokenValiditySeconds(Integer refreshTokenValiditySeconds) {
      this.refreshTokenValiditySeconds = refreshTokenValiditySeconds;
      return this;
    }
  }
}
