package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class CreateProductSelectionDraft {
  private String key;

  private List<LocalizedStringItemInputType> name;

  private ProductSelectionMode mode;

  private CustomFieldsDraft custom;

  public CreateProductSelectionDraft() {
  }

  public CreateProductSelectionDraft(String key, List<LocalizedStringItemInputType> name,
      ProductSelectionMode mode, CustomFieldsDraft custom) {
    this.key = key;
    this.name = name;
    this.mode = mode;
    this.custom = custom;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public List<LocalizedStringItemInputType> getName() {
    return name;
  }

  public void setName(List<LocalizedStringItemInputType> name) {
    this.name = name;
  }

  public ProductSelectionMode getMode() {
    return mode;
  }

  public void setMode(ProductSelectionMode mode) {
    this.mode = mode;
  }

  public CustomFieldsDraft getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsDraft custom) {
    this.custom = custom;
  }

  @Override
  public String toString() {
    return "CreateProductSelectionDraft{key='" + key + "', name='" + name + "', mode='" + mode + "', custom='" + custom + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CreateProductSelectionDraft that = (CreateProductSelectionDraft) o;
    return Objects.equals(key, that.key) &&
        Objects.equals(name, that.name) &&
        Objects.equals(mode, that.mode) &&
        Objects.equals(custom, that.custom);
  }

  @Override
  public int hashCode() {
    return Objects.hash(key, name, mode, custom);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String key;

    private List<LocalizedStringItemInputType> name;

    private ProductSelectionMode mode;

    private CustomFieldsDraft custom;

    public CreateProductSelectionDraft build() {
      CreateProductSelectionDraft result = new CreateProductSelectionDraft();
      result.key = this.key;
      result.name = this.name;
      result.mode = this.mode;
      result.custom = this.custom;
      return result;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder name(List<LocalizedStringItemInputType> name) {
      this.name = name;
      return this;
    }

    public Builder mode(ProductSelectionMode mode) {
      this.mode = mode;
      return this;
    }

    public Builder custom(CustomFieldsDraft custom) {
      this.custom = custom;
      return this;
    }
  }
}
