package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class CreateStore {
  private String key;

  private List<LocalizedStringItemInputType> name;

  private List<String> languages;

  private List<StoreCountryInput> countries;

  private List<ResourceIdentifierInput> distributionChannels;

  private List<ResourceIdentifierInput> supplyChannels;

  private List<ProductSelectionSettingDraft> productSelections;

  private CustomFieldsDraft custom;

  public CreateStore() {
  }

  public CreateStore(String key, List<LocalizedStringItemInputType> name, List<String> languages,
      List<StoreCountryInput> countries, List<ResourceIdentifierInput> distributionChannels,
      List<ResourceIdentifierInput> supplyChannels,
      List<ProductSelectionSettingDraft> productSelections, CustomFieldsDraft custom) {
    this.key = key;
    this.name = name;
    this.languages = languages;
    this.countries = countries;
    this.distributionChannels = distributionChannels;
    this.supplyChannels = supplyChannels;
    this.productSelections = productSelections;
    this.custom = custom;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public List<LocalizedStringItemInputType> getName() {
    return name;
  }

  public void setName(List<LocalizedStringItemInputType> name) {
    this.name = name;
  }

  public List<String> getLanguages() {
    return languages;
  }

  public void setLanguages(List<String> languages) {
    this.languages = languages;
  }

  public List<StoreCountryInput> getCountries() {
    return countries;
  }

  public void setCountries(List<StoreCountryInput> countries) {
    this.countries = countries;
  }

  public List<ResourceIdentifierInput> getDistributionChannels() {
    return distributionChannels;
  }

  public void setDistributionChannels(List<ResourceIdentifierInput> distributionChannels) {
    this.distributionChannels = distributionChannels;
  }

  public List<ResourceIdentifierInput> getSupplyChannels() {
    return supplyChannels;
  }

  public void setSupplyChannels(List<ResourceIdentifierInput> supplyChannels) {
    this.supplyChannels = supplyChannels;
  }

  public List<ProductSelectionSettingDraft> getProductSelections() {
    return productSelections;
  }

  public void setProductSelections(List<ProductSelectionSettingDraft> productSelections) {
    this.productSelections = productSelections;
  }

  public CustomFieldsDraft getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsDraft custom) {
    this.custom = custom;
  }

  @Override
  public String toString() {
    return "CreateStore{key='" + key + "', name='" + name + "', languages='" + languages + "', countries='" + countries + "', distributionChannels='" + distributionChannels + "', supplyChannels='" + supplyChannels + "', productSelections='" + productSelections + "', custom='" + custom + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CreateStore that = (CreateStore) o;
    return Objects.equals(key, that.key) &&
        Objects.equals(name, that.name) &&
        Objects.equals(languages, that.languages) &&
        Objects.equals(countries, that.countries) &&
        Objects.equals(distributionChannels, that.distributionChannels) &&
        Objects.equals(supplyChannels, that.supplyChannels) &&
        Objects.equals(productSelections, that.productSelections) &&
        Objects.equals(custom, that.custom);
  }

  @Override
  public int hashCode() {
    return Objects.hash(key, name, languages, countries, distributionChannels, supplyChannels, productSelections, custom);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String key;

    private List<LocalizedStringItemInputType> name;

    private List<String> languages;

    private List<StoreCountryInput> countries;

    private List<ResourceIdentifierInput> distributionChannels;

    private List<ResourceIdentifierInput> supplyChannels;

    private List<ProductSelectionSettingDraft> productSelections;

    private CustomFieldsDraft custom;

    public CreateStore build() {
      CreateStore result = new CreateStore();
      result.key = this.key;
      result.name = this.name;
      result.languages = this.languages;
      result.countries = this.countries;
      result.distributionChannels = this.distributionChannels;
      result.supplyChannels = this.supplyChannels;
      result.productSelections = this.productSelections;
      result.custom = this.custom;
      return result;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder name(List<LocalizedStringItemInputType> name) {
      this.name = name;
      return this;
    }

    public Builder languages(List<String> languages) {
      this.languages = languages;
      return this;
    }

    public Builder countries(List<StoreCountryInput> countries) {
      this.countries = countries;
      return this;
    }

    public Builder distributionChannels(List<ResourceIdentifierInput> distributionChannels) {
      this.distributionChannels = distributionChannels;
      return this;
    }

    public Builder supplyChannels(List<ResourceIdentifierInput> supplyChannels) {
      this.supplyChannels = supplyChannels;
      return this;
    }

    public Builder productSelections(List<ProductSelectionSettingDraft> productSelections) {
      this.productSelections = productSelections;
      return this;
    }

    public Builder custom(CustomFieldsDraft custom) {
      this.custom = custom;
      return this;
    }
  }
}
