package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class CreateZone {
  private String name;

  private String key;

  private String description;

  private List<ZoneLocation> locations = Collections.emptyList();

  public CreateZone() {
  }

  public CreateZone(String name, String key, String description, List<ZoneLocation> locations) {
    this.name = name;
    this.key = key;
    this.description = description;
    this.locations = locations;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public List<ZoneLocation> getLocations() {
    return locations;
  }

  public void setLocations(List<ZoneLocation> locations) {
    this.locations = locations;
  }

  @Override
  public String toString() {
    return "CreateZone{name='" + name + "', key='" + key + "', description='" + description + "', locations='" + locations + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CreateZone that = (CreateZone) o;
    return Objects.equals(name, that.name) &&
        Objects.equals(key, that.key) &&
        Objects.equals(description, that.description) &&
        Objects.equals(locations, that.locations);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, key, description, locations);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String name;

    private String key;

    private String description;

    private List<ZoneLocation> locations = Collections.emptyList();

    public CreateZone build() {
      CreateZone result = new CreateZone();
      result.name = this.name;
      result.key = this.key;
      result.description = this.description;
      result.locations = this.locations;
      return result;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder description(String description) {
      this.description = description;
      return this;
    }

    public Builder locations(List<ZoneLocation> locations) {
      this.locations = locations;
      return this;
    }
  }
}
