package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.databind.JsonNode;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class CustomFieldsCommand {
  private String typeId;

  private String typeKey;

  private JsonNode fields;

  private ResourceIdentifier typeResId;

  public CustomFieldsCommand() {
  }

  public CustomFieldsCommand(String typeId, String typeKey, JsonNode fields,
      ResourceIdentifier typeResId) {
    this.typeId = typeId;
    this.typeKey = typeKey;
    this.fields = fields;
    this.typeResId = typeResId;
  }

  public String getTypeId() {
    return typeId;
  }

  public void setTypeId(String typeId) {
    this.typeId = typeId;
  }

  public String getTypeKey() {
    return typeKey;
  }

  public void setTypeKey(String typeKey) {
    this.typeKey = typeKey;
  }

  public JsonNode getFields() {
    return fields;
  }

  public void setFields(JsonNode fields) {
    this.fields = fields;
  }

  public ResourceIdentifier getTypeResId() {
    return typeResId;
  }

  public void setTypeResId(ResourceIdentifier typeResId) {
    this.typeResId = typeResId;
  }

  @Override
  public String toString() {
    return "CustomFieldsCommand{typeId='" + typeId + "', typeKey='" + typeKey + "', fields='" + fields + "', typeResId='" + typeResId + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CustomFieldsCommand that = (CustomFieldsCommand) o;
    return Objects.equals(typeId, that.typeId) &&
        Objects.equals(typeKey, that.typeKey) &&
        Objects.equals(fields, that.fields) &&
        Objects.equals(typeResId, that.typeResId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(typeId, typeKey, fields, typeResId);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String typeId;

    private String typeKey;

    private JsonNode fields;

    private ResourceIdentifier typeResId;

    public CustomFieldsCommand build() {
      CustomFieldsCommand result = new CustomFieldsCommand();
      result.typeId = this.typeId;
      result.typeKey = this.typeKey;
      result.fields = this.fields;
      result.typeResId = this.typeResId;
      return result;
    }

    public Builder typeId(String typeId) {
      this.typeId = typeId;
      return this;
    }

    public Builder typeKey(String typeKey) {
      this.typeKey = typeKey;
      return this;
    }

    public Builder fields(JsonNode fields) {
      this.fields = fields;
      return this;
    }

    public Builder typeResId(ResourceIdentifier typeResId) {
      this.typeResId = typeResId;
      return this;
    }
  }
}
