package com.commercetools.graphql.api.types;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

/**
 * A custom line item is a generic item that can be added to the cart but is not bound to a product. You can use it for discounts (negative money), vouchers, complex cart rules, additional services or fees. You control the lifecycle of this item.
 */
public class CustomLineItem {
  private String id;

  private String key;

  private String name;

  private List<LocalizedString> nameAllLocales;

  private BaseMoney money;

  private Money totalPrice;

  private String slug;

  private Long quantity;

  private List<ItemState> state;

  private TaxCategory taxCategory;

  private Reference taxCategoryRef;

  private TaxRate taxRate;

  private TaxedItemPrice taxedPrice;

  private List<MethodTaxedPrice> taxedPricePortions;

  private List<MethodTaxRate> perMethodTaxRate;

  private List<DiscountedLineItemPriceForQuantity> discountedPricePerQuantity;

  private CustomFieldsType custom;

  private ItemShippingDetails shippingDetails;

  private CustomLineItemPriceMode priceMode;

  public CustomLineItem() {
  }

  public CustomLineItem(String id, String key, String name, List<LocalizedString> nameAllLocales,
      BaseMoney money, Money totalPrice, String slug, Long quantity, List<ItemState> state,
      TaxCategory taxCategory, Reference taxCategoryRef, TaxRate taxRate, TaxedItemPrice taxedPrice,
      List<MethodTaxedPrice> taxedPricePortions, List<MethodTaxRate> perMethodTaxRate,
      List<DiscountedLineItemPriceForQuantity> discountedPricePerQuantity, CustomFieldsType custom,
      ItemShippingDetails shippingDetails, CustomLineItemPriceMode priceMode) {
    this.id = id;
    this.key = key;
    this.name = name;
    this.nameAllLocales = nameAllLocales;
    this.money = money;
    this.totalPrice = totalPrice;
    this.slug = slug;
    this.quantity = quantity;
    this.state = state;
    this.taxCategory = taxCategory;
    this.taxCategoryRef = taxCategoryRef;
    this.taxRate = taxRate;
    this.taxedPrice = taxedPrice;
    this.taxedPricePortions = taxedPricePortions;
    this.perMethodTaxRate = perMethodTaxRate;
    this.discountedPricePerQuantity = discountedPricePerQuantity;
    this.custom = custom;
    this.shippingDetails = shippingDetails;
    this.priceMode = priceMode;
  }

  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public List<LocalizedString> getNameAllLocales() {
    return nameAllLocales;
  }

  public void setNameAllLocales(List<LocalizedString> nameAllLocales) {
    this.nameAllLocales = nameAllLocales;
  }

  public BaseMoney getMoney() {
    return money;
  }

  public void setMoney(BaseMoney money) {
    this.money = money;
  }

  public Money getTotalPrice() {
    return totalPrice;
  }

  public void setTotalPrice(Money totalPrice) {
    this.totalPrice = totalPrice;
  }

  public String getSlug() {
    return slug;
  }

  public void setSlug(String slug) {
    this.slug = slug;
  }

  public Long getQuantity() {
    return quantity;
  }

  public void setQuantity(Long quantity) {
    this.quantity = quantity;
  }

  public List<ItemState> getState() {
    return state;
  }

  public void setState(List<ItemState> state) {
    this.state = state;
  }

  public TaxCategory getTaxCategory() {
    return taxCategory;
  }

  public void setTaxCategory(TaxCategory taxCategory) {
    this.taxCategory = taxCategory;
  }

  public Reference getTaxCategoryRef() {
    return taxCategoryRef;
  }

  public void setTaxCategoryRef(Reference taxCategoryRef) {
    this.taxCategoryRef = taxCategoryRef;
  }

  public TaxRate getTaxRate() {
    return taxRate;
  }

  public void setTaxRate(TaxRate taxRate) {
    this.taxRate = taxRate;
  }

  public TaxedItemPrice getTaxedPrice() {
    return taxedPrice;
  }

  public void setTaxedPrice(TaxedItemPrice taxedPrice) {
    this.taxedPrice = taxedPrice;
  }

  public List<MethodTaxedPrice> getTaxedPricePortions() {
    return taxedPricePortions;
  }

  public void setTaxedPricePortions(List<MethodTaxedPrice> taxedPricePortions) {
    this.taxedPricePortions = taxedPricePortions;
  }

  public List<MethodTaxRate> getPerMethodTaxRate() {
    return perMethodTaxRate;
  }

  public void setPerMethodTaxRate(List<MethodTaxRate> perMethodTaxRate) {
    this.perMethodTaxRate = perMethodTaxRate;
  }

  public List<DiscountedLineItemPriceForQuantity> getDiscountedPricePerQuantity() {
    return discountedPricePerQuantity;
  }

  public void setDiscountedPricePerQuantity(
      List<DiscountedLineItemPriceForQuantity> discountedPricePerQuantity) {
    this.discountedPricePerQuantity = discountedPricePerQuantity;
  }

  public CustomFieldsType getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsType custom) {
    this.custom = custom;
  }

  public ItemShippingDetails getShippingDetails() {
    return shippingDetails;
  }

  public void setShippingDetails(ItemShippingDetails shippingDetails) {
    this.shippingDetails = shippingDetails;
  }

  public CustomLineItemPriceMode getPriceMode() {
    return priceMode;
  }

  public void setPriceMode(CustomLineItemPriceMode priceMode) {
    this.priceMode = priceMode;
  }

  @Override
  public String toString() {
    return "CustomLineItem{id='" + id + "', key='" + key + "', name='" + name + "', nameAllLocales='" + nameAllLocales + "', money='" + money + "', totalPrice='" + totalPrice + "', slug='" + slug + "', quantity='" + quantity + "', state='" + state + "', taxCategory='" + taxCategory + "', taxCategoryRef='" + taxCategoryRef + "', taxRate='" + taxRate + "', taxedPrice='" + taxedPrice + "', taxedPricePortions='" + taxedPricePortions + "', perMethodTaxRate='" + perMethodTaxRate + "', discountedPricePerQuantity='" + discountedPricePerQuantity + "', custom='" + custom + "', shippingDetails='" + shippingDetails + "', priceMode='" + priceMode + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CustomLineItem that = (CustomLineItem) o;
    return Objects.equals(id, that.id) &&
        Objects.equals(key, that.key) &&
        Objects.equals(name, that.name) &&
        Objects.equals(nameAllLocales, that.nameAllLocales) &&
        Objects.equals(money, that.money) &&
        Objects.equals(totalPrice, that.totalPrice) &&
        Objects.equals(slug, that.slug) &&
        Objects.equals(quantity, that.quantity) &&
        Objects.equals(state, that.state) &&
        Objects.equals(taxCategory, that.taxCategory) &&
        Objects.equals(taxCategoryRef, that.taxCategoryRef) &&
        Objects.equals(taxRate, that.taxRate) &&
        Objects.equals(taxedPrice, that.taxedPrice) &&
        Objects.equals(taxedPricePortions, that.taxedPricePortions) &&
        Objects.equals(perMethodTaxRate, that.perMethodTaxRate) &&
        Objects.equals(discountedPricePerQuantity, that.discountedPricePerQuantity) &&
        Objects.equals(custom, that.custom) &&
        Objects.equals(shippingDetails, that.shippingDetails) &&
        Objects.equals(priceMode, that.priceMode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, key, name, nameAllLocales, money, totalPrice, slug, quantity, state, taxCategory, taxCategoryRef, taxRate, taxedPrice, taxedPricePortions, perMethodTaxRate, discountedPricePerQuantity, custom, shippingDetails, priceMode);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String id;

    private String key;

    private String name;

    private List<LocalizedString> nameAllLocales;

    private BaseMoney money;

    private Money totalPrice;

    private String slug;

    private Long quantity;

    private List<ItemState> state;

    private TaxCategory taxCategory;

    private Reference taxCategoryRef;

    private TaxRate taxRate;

    private TaxedItemPrice taxedPrice;

    private List<MethodTaxedPrice> taxedPricePortions;

    private List<MethodTaxRate> perMethodTaxRate;

    private List<DiscountedLineItemPriceForQuantity> discountedPricePerQuantity;

    private CustomFieldsType custom;

    private ItemShippingDetails shippingDetails;

    private CustomLineItemPriceMode priceMode;

    public CustomLineItem build() {
      CustomLineItem result = new CustomLineItem();
      result.id = this.id;
      result.key = this.key;
      result.name = this.name;
      result.nameAllLocales = this.nameAllLocales;
      result.money = this.money;
      result.totalPrice = this.totalPrice;
      result.slug = this.slug;
      result.quantity = this.quantity;
      result.state = this.state;
      result.taxCategory = this.taxCategory;
      result.taxCategoryRef = this.taxCategoryRef;
      result.taxRate = this.taxRate;
      result.taxedPrice = this.taxedPrice;
      result.taxedPricePortions = this.taxedPricePortions;
      result.perMethodTaxRate = this.perMethodTaxRate;
      result.discountedPricePerQuantity = this.discountedPricePerQuantity;
      result.custom = this.custom;
      result.shippingDetails = this.shippingDetails;
      result.priceMode = this.priceMode;
      return result;
    }

    public Builder id(String id) {
      this.id = id;
      return this;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }

    public Builder nameAllLocales(List<LocalizedString> nameAllLocales) {
      this.nameAllLocales = nameAllLocales;
      return this;
    }

    public Builder money(BaseMoney money) {
      this.money = money;
      return this;
    }

    public Builder totalPrice(Money totalPrice) {
      this.totalPrice = totalPrice;
      return this;
    }

    public Builder slug(String slug) {
      this.slug = slug;
      return this;
    }

    public Builder quantity(Long quantity) {
      this.quantity = quantity;
      return this;
    }

    public Builder state(List<ItemState> state) {
      this.state = state;
      return this;
    }

    public Builder taxCategory(TaxCategory taxCategory) {
      this.taxCategory = taxCategory;
      return this;
    }

    public Builder taxCategoryRef(Reference taxCategoryRef) {
      this.taxCategoryRef = taxCategoryRef;
      return this;
    }

    public Builder taxRate(TaxRate taxRate) {
      this.taxRate = taxRate;
      return this;
    }

    public Builder taxedPrice(TaxedItemPrice taxedPrice) {
      this.taxedPrice = taxedPrice;
      return this;
    }

    public Builder taxedPricePortions(List<MethodTaxedPrice> taxedPricePortions) {
      this.taxedPricePortions = taxedPricePortions;
      return this;
    }

    public Builder perMethodTaxRate(List<MethodTaxRate> perMethodTaxRate) {
      this.perMethodTaxRate = perMethodTaxRate;
      return this;
    }

    public Builder discountedPricePerQuantity(
        List<DiscountedLineItemPriceForQuantity> discountedPricePerQuantity) {
      this.discountedPricePerQuantity = discountedPricePerQuantity;
      return this;
    }

    public Builder custom(CustomFieldsType custom) {
      this.custom = custom;
      return this;
    }

    public Builder shippingDetails(ItemShippingDetails shippingDetails) {
      this.shippingDetails = shippingDetails;
      return this;
    }

    public Builder priceMode(CustomLineItemPriceMode priceMode) {
      this.priceMode = priceMode;
      return this;
    }
  }
}
