package com.commercetools.graphql.api.types;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class CustomLineItemDraft {
  private List<LocalizedStringItemInputType> name;

  private String key;

  private BaseMoneyInput money;

  private String slug;

  private ReferenceInput taxCategory;

  private ExternalTaxRateDraft externalTaxRate;

  private Long quantity;

  private CustomFieldsDraft custom;

  private ItemShippingDetailsDraft shippingDetails;

  private CustomLineItemPriceMode priceMode;

  public CustomLineItemDraft() {
  }

  public CustomLineItemDraft(List<LocalizedStringItemInputType> name, String key,
      BaseMoneyInput money, String slug, ReferenceInput taxCategory,
      ExternalTaxRateDraft externalTaxRate, Long quantity, CustomFieldsDraft custom,
      ItemShippingDetailsDraft shippingDetails, CustomLineItemPriceMode priceMode) {
    this.name = name;
    this.key = key;
    this.money = money;
    this.slug = slug;
    this.taxCategory = taxCategory;
    this.externalTaxRate = externalTaxRate;
    this.quantity = quantity;
    this.custom = custom;
    this.shippingDetails = shippingDetails;
    this.priceMode = priceMode;
  }

  public List<LocalizedStringItemInputType> getName() {
    return name;
  }

  public void setName(List<LocalizedStringItemInputType> name) {
    this.name = name;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public BaseMoneyInput getMoney() {
    return money;
  }

  public void setMoney(BaseMoneyInput money) {
    this.money = money;
  }

  public String getSlug() {
    return slug;
  }

  public void setSlug(String slug) {
    this.slug = slug;
  }

  public ReferenceInput getTaxCategory() {
    return taxCategory;
  }

  public void setTaxCategory(ReferenceInput taxCategory) {
    this.taxCategory = taxCategory;
  }

  public ExternalTaxRateDraft getExternalTaxRate() {
    return externalTaxRate;
  }

  public void setExternalTaxRate(ExternalTaxRateDraft externalTaxRate) {
    this.externalTaxRate = externalTaxRate;
  }

  public Long getQuantity() {
    return quantity;
  }

  public void setQuantity(Long quantity) {
    this.quantity = quantity;
  }

  public CustomFieldsDraft getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsDraft custom) {
    this.custom = custom;
  }

  public ItemShippingDetailsDraft getShippingDetails() {
    return shippingDetails;
  }

  public void setShippingDetails(ItemShippingDetailsDraft shippingDetails) {
    this.shippingDetails = shippingDetails;
  }

  public CustomLineItemPriceMode getPriceMode() {
    return priceMode;
  }

  public void setPriceMode(CustomLineItemPriceMode priceMode) {
    this.priceMode = priceMode;
  }

  @Override
  public String toString() {
    return "CustomLineItemDraft{name='" + name + "', key='" + key + "', money='" + money + "', slug='" + slug + "', taxCategory='" + taxCategory + "', externalTaxRate='" + externalTaxRate + "', quantity='" + quantity + "', custom='" + custom + "', shippingDetails='" + shippingDetails + "', priceMode='" + priceMode + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CustomLineItemDraft that = (CustomLineItemDraft) o;
    return Objects.equals(name, that.name) &&
        Objects.equals(key, that.key) &&
        Objects.equals(money, that.money) &&
        Objects.equals(slug, that.slug) &&
        Objects.equals(taxCategory, that.taxCategory) &&
        Objects.equals(externalTaxRate, that.externalTaxRate) &&
        Objects.equals(quantity, that.quantity) &&
        Objects.equals(custom, that.custom) &&
        Objects.equals(shippingDetails, that.shippingDetails) &&
        Objects.equals(priceMode, that.priceMode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, key, money, slug, taxCategory, externalTaxRate, quantity, custom, shippingDetails, priceMode);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<LocalizedStringItemInputType> name;

    private String key;

    private BaseMoneyInput money;

    private String slug;

    private ReferenceInput taxCategory;

    private ExternalTaxRateDraft externalTaxRate;

    private Long quantity;

    private CustomFieldsDraft custom;

    private ItemShippingDetailsDraft shippingDetails;

    private CustomLineItemPriceMode priceMode;

    public CustomLineItemDraft build() {
      CustomLineItemDraft result = new CustomLineItemDraft();
      result.name = this.name;
      result.key = this.key;
      result.money = this.money;
      result.slug = this.slug;
      result.taxCategory = this.taxCategory;
      result.externalTaxRate = this.externalTaxRate;
      result.quantity = this.quantity;
      result.custom = this.custom;
      result.shippingDetails = this.shippingDetails;
      result.priceMode = this.priceMode;
      return result;
    }

    public Builder name(List<LocalizedStringItemInputType> name) {
      this.name = name;
      return this;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder money(BaseMoneyInput money) {
      this.money = money;
      return this;
    }

    public Builder slug(String slug) {
      this.slug = slug;
      return this;
    }

    public Builder taxCategory(ReferenceInput taxCategory) {
      this.taxCategory = taxCategory;
      return this;
    }

    public Builder externalTaxRate(ExternalTaxRateDraft externalTaxRate) {
      this.externalTaxRate = externalTaxRate;
      return this;
    }

    public Builder quantity(Long quantity) {
      this.quantity = quantity;
      return this;
    }

    public Builder custom(CustomFieldsDraft custom) {
      this.custom = custom;
      return this;
    }

    public Builder shippingDetails(ItemShippingDetailsDraft shippingDetails) {
      this.shippingDetails = shippingDetails;
      return this;
    }

    public Builder priceMode(CustomLineItemPriceMode priceMode) {
      this.priceMode = priceMode;
      return this;
    }
  }
}
