package com.commercetools.graphql.api.types;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class CustomLineItemDraftOutput {
  private String key;

  private BaseMoney money;

  private String slug;

  private ExternalTaxRateDraftOutput externalTaxRate;

  private Long quantity;

  private CustomFieldsCommand custom;

  private ItemShippingDetailsDraftOutput shippingDetails;

  private CustomLineItemPriceMode priceMode;

  private String name;

  private ResourceIdentifier taxCategoryResId;

  private List<LocalizedString> nameAllLocales;

  public CustomLineItemDraftOutput() {
  }

  public CustomLineItemDraftOutput(String key, BaseMoney money, String slug,
      ExternalTaxRateDraftOutput externalTaxRate, Long quantity, CustomFieldsCommand custom,
      ItemShippingDetailsDraftOutput shippingDetails, CustomLineItemPriceMode priceMode,
      String name, ResourceIdentifier taxCategoryResId, List<LocalizedString> nameAllLocales) {
    this.key = key;
    this.money = money;
    this.slug = slug;
    this.externalTaxRate = externalTaxRate;
    this.quantity = quantity;
    this.custom = custom;
    this.shippingDetails = shippingDetails;
    this.priceMode = priceMode;
    this.name = name;
    this.taxCategoryResId = taxCategoryResId;
    this.nameAllLocales = nameAllLocales;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public BaseMoney getMoney() {
    return money;
  }

  public void setMoney(BaseMoney money) {
    this.money = money;
  }

  public String getSlug() {
    return slug;
  }

  public void setSlug(String slug) {
    this.slug = slug;
  }

  public ExternalTaxRateDraftOutput getExternalTaxRate() {
    return externalTaxRate;
  }

  public void setExternalTaxRate(ExternalTaxRateDraftOutput externalTaxRate) {
    this.externalTaxRate = externalTaxRate;
  }

  public Long getQuantity() {
    return quantity;
  }

  public void setQuantity(Long quantity) {
    this.quantity = quantity;
  }

  public CustomFieldsCommand getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsCommand custom) {
    this.custom = custom;
  }

  public ItemShippingDetailsDraftOutput getShippingDetails() {
    return shippingDetails;
  }

  public void setShippingDetails(ItemShippingDetailsDraftOutput shippingDetails) {
    this.shippingDetails = shippingDetails;
  }

  public CustomLineItemPriceMode getPriceMode() {
    return priceMode;
  }

  public void setPriceMode(CustomLineItemPriceMode priceMode) {
    this.priceMode = priceMode;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public ResourceIdentifier getTaxCategoryResId() {
    return taxCategoryResId;
  }

  public void setTaxCategoryResId(ResourceIdentifier taxCategoryResId) {
    this.taxCategoryResId = taxCategoryResId;
  }

  public List<LocalizedString> getNameAllLocales() {
    return nameAllLocales;
  }

  public void setNameAllLocales(List<LocalizedString> nameAllLocales) {
    this.nameAllLocales = nameAllLocales;
  }

  @Override
  public String toString() {
    return "CustomLineItemDraftOutput{key='" + key + "', money='" + money + "', slug='" + slug + "', externalTaxRate='" + externalTaxRate + "', quantity='" + quantity + "', custom='" + custom + "', shippingDetails='" + shippingDetails + "', priceMode='" + priceMode + "', name='" + name + "', taxCategoryResId='" + taxCategoryResId + "', nameAllLocales='" + nameAllLocales + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CustomLineItemDraftOutput that = (CustomLineItemDraftOutput) o;
    return Objects.equals(key, that.key) &&
        Objects.equals(money, that.money) &&
        Objects.equals(slug, that.slug) &&
        Objects.equals(externalTaxRate, that.externalTaxRate) &&
        Objects.equals(quantity, that.quantity) &&
        Objects.equals(custom, that.custom) &&
        Objects.equals(shippingDetails, that.shippingDetails) &&
        Objects.equals(priceMode, that.priceMode) &&
        Objects.equals(name, that.name) &&
        Objects.equals(taxCategoryResId, that.taxCategoryResId) &&
        Objects.equals(nameAllLocales, that.nameAllLocales);
  }

  @Override
  public int hashCode() {
    return Objects.hash(key, money, slug, externalTaxRate, quantity, custom, shippingDetails, priceMode, name, taxCategoryResId, nameAllLocales);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String key;

    private BaseMoney money;

    private String slug;

    private ExternalTaxRateDraftOutput externalTaxRate;

    private Long quantity;

    private CustomFieldsCommand custom;

    private ItemShippingDetailsDraftOutput shippingDetails;

    private CustomLineItemPriceMode priceMode;

    private String name;

    private ResourceIdentifier taxCategoryResId;

    private List<LocalizedString> nameAllLocales;

    public CustomLineItemDraftOutput build() {
      CustomLineItemDraftOutput result = new CustomLineItemDraftOutput();
      result.key = this.key;
      result.money = this.money;
      result.slug = this.slug;
      result.externalTaxRate = this.externalTaxRate;
      result.quantity = this.quantity;
      result.custom = this.custom;
      result.shippingDetails = this.shippingDetails;
      result.priceMode = this.priceMode;
      result.name = this.name;
      result.taxCategoryResId = this.taxCategoryResId;
      result.nameAllLocales = this.nameAllLocales;
      return result;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder money(BaseMoney money) {
      this.money = money;
      return this;
    }

    public Builder slug(String slug) {
      this.slug = slug;
      return this;
    }

    public Builder externalTaxRate(ExternalTaxRateDraftOutput externalTaxRate) {
      this.externalTaxRate = externalTaxRate;
      return this;
    }

    public Builder quantity(Long quantity) {
      this.quantity = quantity;
      return this;
    }

    public Builder custom(CustomFieldsCommand custom) {
      this.custom = custom;
      return this;
    }

    public Builder shippingDetails(ItemShippingDetailsDraftOutput shippingDetails) {
      this.shippingDetails = shippingDetails;
      return this;
    }

    public Builder priceMode(CustomLineItemPriceMode priceMode) {
      this.priceMode = priceMode;
      return this;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }

    public Builder taxCategoryResId(ResourceIdentifier taxCategoryResId) {
      this.taxCategoryResId = taxCategoryResId;
      return this;
    }

    public Builder nameAllLocales(List<LocalizedString> nameAllLocales) {
      this.nameAllLocales = nameAllLocales;
      return this;
    }
  }
}
