package com.commercetools.graphql.api.types;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class CustomLineItemImportDraft {
  private List<LocalizedStringItemInputType> name;

  private String key;

  private Long quantity;

  private BaseMoneyInput money;

  private String slug;

  private List<ItemStateDraftType> state;

  private TaxRateInput taxRate;

  private ResourceIdentifierInput taxCategory;

  private CustomFieldsDraft custom;

  private ItemShippingDetailsDraft shippingDetails;

  private CustomLineItemPriceMode priceMode;

  public CustomLineItemImportDraft() {
  }

  public CustomLineItemImportDraft(List<LocalizedStringItemInputType> name, String key,
      Long quantity, BaseMoneyInput money, String slug, List<ItemStateDraftType> state,
      TaxRateInput taxRate, ResourceIdentifierInput taxCategory, CustomFieldsDraft custom,
      ItemShippingDetailsDraft shippingDetails, CustomLineItemPriceMode priceMode) {
    this.name = name;
    this.key = key;
    this.quantity = quantity;
    this.money = money;
    this.slug = slug;
    this.state = state;
    this.taxRate = taxRate;
    this.taxCategory = taxCategory;
    this.custom = custom;
    this.shippingDetails = shippingDetails;
    this.priceMode = priceMode;
  }

  public List<LocalizedStringItemInputType> getName() {
    return name;
  }

  public void setName(List<LocalizedStringItemInputType> name) {
    this.name = name;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public Long getQuantity() {
    return quantity;
  }

  public void setQuantity(Long quantity) {
    this.quantity = quantity;
  }

  public BaseMoneyInput getMoney() {
    return money;
  }

  public void setMoney(BaseMoneyInput money) {
    this.money = money;
  }

  public String getSlug() {
    return slug;
  }

  public void setSlug(String slug) {
    this.slug = slug;
  }

  public List<ItemStateDraftType> getState() {
    return state;
  }

  public void setState(List<ItemStateDraftType> state) {
    this.state = state;
  }

  public TaxRateInput getTaxRate() {
    return taxRate;
  }

  public void setTaxRate(TaxRateInput taxRate) {
    this.taxRate = taxRate;
  }

  public ResourceIdentifierInput getTaxCategory() {
    return taxCategory;
  }

  public void setTaxCategory(ResourceIdentifierInput taxCategory) {
    this.taxCategory = taxCategory;
  }

  public CustomFieldsDraft getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsDraft custom) {
    this.custom = custom;
  }

  public ItemShippingDetailsDraft getShippingDetails() {
    return shippingDetails;
  }

  public void setShippingDetails(ItemShippingDetailsDraft shippingDetails) {
    this.shippingDetails = shippingDetails;
  }

  public CustomLineItemPriceMode getPriceMode() {
    return priceMode;
  }

  public void setPriceMode(CustomLineItemPriceMode priceMode) {
    this.priceMode = priceMode;
  }

  @Override
  public String toString() {
    return "CustomLineItemImportDraft{name='" + name + "', key='" + key + "', quantity='" + quantity + "', money='" + money + "', slug='" + slug + "', state='" + state + "', taxRate='" + taxRate + "', taxCategory='" + taxCategory + "', custom='" + custom + "', shippingDetails='" + shippingDetails + "', priceMode='" + priceMode + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CustomLineItemImportDraft that = (CustomLineItemImportDraft) o;
    return Objects.equals(name, that.name) &&
        Objects.equals(key, that.key) &&
        Objects.equals(quantity, that.quantity) &&
        Objects.equals(money, that.money) &&
        Objects.equals(slug, that.slug) &&
        Objects.equals(state, that.state) &&
        Objects.equals(taxRate, that.taxRate) &&
        Objects.equals(taxCategory, that.taxCategory) &&
        Objects.equals(custom, that.custom) &&
        Objects.equals(shippingDetails, that.shippingDetails) &&
        Objects.equals(priceMode, that.priceMode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, key, quantity, money, slug, state, taxRate, taxCategory, custom, shippingDetails, priceMode);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<LocalizedStringItemInputType> name;

    private String key;

    private Long quantity;

    private BaseMoneyInput money;

    private String slug;

    private List<ItemStateDraftType> state;

    private TaxRateInput taxRate;

    private ResourceIdentifierInput taxCategory;

    private CustomFieldsDraft custom;

    private ItemShippingDetailsDraft shippingDetails;

    private CustomLineItemPriceMode priceMode;

    public CustomLineItemImportDraft build() {
      CustomLineItemImportDraft result = new CustomLineItemImportDraft();
      result.name = this.name;
      result.key = this.key;
      result.quantity = this.quantity;
      result.money = this.money;
      result.slug = this.slug;
      result.state = this.state;
      result.taxRate = this.taxRate;
      result.taxCategory = this.taxCategory;
      result.custom = this.custom;
      result.shippingDetails = this.shippingDetails;
      result.priceMode = this.priceMode;
      return result;
    }

    public Builder name(List<LocalizedStringItemInputType> name) {
      this.name = name;
      return this;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder quantity(Long quantity) {
      this.quantity = quantity;
      return this;
    }

    public Builder money(BaseMoneyInput money) {
      this.money = money;
      return this;
    }

    public Builder slug(String slug) {
      this.slug = slug;
      return this;
    }

    public Builder state(List<ItemStateDraftType> state) {
      this.state = state;
      return this;
    }

    public Builder taxRate(TaxRateInput taxRate) {
      this.taxRate = taxRate;
      return this;
    }

    public Builder taxCategory(ResourceIdentifierInput taxCategory) {
      this.taxCategory = taxCategory;
      return this;
    }

    public Builder custom(CustomFieldsDraft custom) {
      this.custom = custom;
      return this;
    }

    public Builder shippingDetails(ItemShippingDetailsDraft shippingDetails) {
      this.shippingDetails = shippingDetails;
      return this;
    }

    public Builder priceMode(CustomLineItemPriceMode priceMode) {
      this.priceMode = priceMode;
      return this;
    }
  }
}
