package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class CustomObjectLimitsProjection {
  private CustomObjectLimitWithCurrent total;

  public CustomObjectLimitsProjection() {
  }

  public CustomObjectLimitsProjection(CustomObjectLimitWithCurrent total) {
    this.total = total;
  }

  public CustomObjectLimitWithCurrent getTotal() {
    return total;
  }

  public void setTotal(CustomObjectLimitWithCurrent total) {
    this.total = total;
  }

  @Override
  public String toString() {
    return "CustomObjectLimitsProjection{total='" + total + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CustomObjectLimitsProjection that = (CustomObjectLimitsProjection) o;
    return Objects.equals(total, that.total);
  }

  @Override
  public int hashCode() {
    return Objects.hash(total);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private CustomObjectLimitWithCurrent total;

    public CustomObjectLimitsProjection build() {
      CustomObjectLimitsProjection result = new CustomObjectLimitsProjection();
      result.total = this.total;
      return result;
    }

    public Builder total(CustomObjectLimitWithCurrent total) {
      this.total = total;
      return this;
    }
  }
}
