package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class CustomSuggestTokenizerProductSearch implements com.commercetools.graphql.api.types.SuggestTokenizerProductSearch {
  private List<String> inputs;

  private String type;

  public CustomSuggestTokenizerProductSearch() {
  }

  public CustomSuggestTokenizerProductSearch(List<String> inputs, String type) {
    this.inputs = inputs;
    this.type = type;
  }

  public List<String> getInputs() {
    return inputs;
  }

  public void setInputs(List<String> inputs) {
    this.inputs = inputs;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "CustomSuggestTokenizerProductSearch{inputs='" + inputs + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CustomSuggestTokenizerProductSearch that = (CustomSuggestTokenizerProductSearch) o;
    return Objects.equals(inputs, that.inputs) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(inputs, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<String> inputs;

    private String type;

    public CustomSuggestTokenizerProductSearch build() {
      CustomSuggestTokenizerProductSearch result = new CustomSuggestTokenizerProductSearch();
      result.inputs = this.inputs;
      result.type = this.type;
      return result;
    }

    public Builder inputs(List<String> inputs) {
      this.inputs = inputs;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
