package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Boolean;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;

/**
 * A customer is a person purchasing products. Carts, Orders and Reviews can be associated to a customer.
 */
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class Customer implements com.commercetools.graphql.api.types.Versioned, com.commercetools.graphql.api.types.ReferenceExpandable {
  private String customerNumber;

  private String email;

  private List<Address> addresses;

  private String defaultShippingAddressId;

  private String defaultBillingAddressId;

  private List<String> shippingAddressIds;

  private List<String> billingAddressIds;

  private Boolean isEmailVerified;

  private Reference customerGroupRef;

  private String externalId;

  private String key;

  private AuthenticationMode authenticationMode;

  private String firstName;

  private String lastName;

  private String middleName;

  private String title;

  private String locale;

  private String salutation;

  private LocalDate dateOfBirth;

  private String companyName;

  private String vatId;

  private String password;

  private CustomerGroup customerGroup;

  private Address defaultShippingAddress;

  private Address defaultBillingAddress;

  private List<Address> shippingAddresses;

  private List<Address> billingAddresses;

  private List<KeyReference> storesRef;

  private List<Store> stores;

  /**
   * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
   */
  private List<CustomerGroupAssignment> customerGroupAssignments;

  private CustomFieldsType custom;

  private String id;

  private Long version;

  private OffsetDateTime createdAt;

  private OffsetDateTime lastModifiedAt;

  private Initiator createdBy;

  private Initiator lastModifiedBy;

  public Customer() {
  }

  public Customer(String customerNumber, String email, List<Address> addresses,
      String defaultShippingAddressId, String defaultBillingAddressId,
      List<String> shippingAddressIds, List<String> billingAddressIds, Boolean isEmailVerified,
      Reference customerGroupRef, String externalId, String key,
      AuthenticationMode authenticationMode, String firstName, String lastName, String middleName,
      String title, String locale, String salutation, LocalDate dateOfBirth, String companyName,
      String vatId, String password, CustomerGroup customerGroup, Address defaultShippingAddress,
      Address defaultBillingAddress, List<Address> shippingAddresses,
      List<Address> billingAddresses, List<KeyReference> storesRef, List<Store> stores,
      List<CustomerGroupAssignment> customerGroupAssignments, CustomFieldsType custom, String id,
      Long version, OffsetDateTime createdAt, OffsetDateTime lastModifiedAt, Initiator createdBy,
      Initiator lastModifiedBy) {
    this.customerNumber = customerNumber;
    this.email = email;
    this.addresses = addresses;
    this.defaultShippingAddressId = defaultShippingAddressId;
    this.defaultBillingAddressId = defaultBillingAddressId;
    this.shippingAddressIds = shippingAddressIds;
    this.billingAddressIds = billingAddressIds;
    this.isEmailVerified = isEmailVerified;
    this.customerGroupRef = customerGroupRef;
    this.externalId = externalId;
    this.key = key;
    this.authenticationMode = authenticationMode;
    this.firstName = firstName;
    this.lastName = lastName;
    this.middleName = middleName;
    this.title = title;
    this.locale = locale;
    this.salutation = salutation;
    this.dateOfBirth = dateOfBirth;
    this.companyName = companyName;
    this.vatId = vatId;
    this.password = password;
    this.customerGroup = customerGroup;
    this.defaultShippingAddress = defaultShippingAddress;
    this.defaultBillingAddress = defaultBillingAddress;
    this.shippingAddresses = shippingAddresses;
    this.billingAddresses = billingAddresses;
    this.storesRef = storesRef;
    this.stores = stores;
    this.customerGroupAssignments = customerGroupAssignments;
    this.custom = custom;
    this.id = id;
    this.version = version;
    this.createdAt = createdAt;
    this.lastModifiedAt = lastModifiedAt;
    this.createdBy = createdBy;
    this.lastModifiedBy = lastModifiedBy;
  }

  public String getCustomerNumber() {
    return customerNumber;
  }

  public void setCustomerNumber(String customerNumber) {
    this.customerNumber = customerNumber;
  }

  public String getEmail() {
    return email;
  }

  public void setEmail(String email) {
    this.email = email;
  }

  public List<Address> getAddresses() {
    return addresses;
  }

  public void setAddresses(List<Address> addresses) {
    this.addresses = addresses;
  }

  public String getDefaultShippingAddressId() {
    return defaultShippingAddressId;
  }

  public void setDefaultShippingAddressId(String defaultShippingAddressId) {
    this.defaultShippingAddressId = defaultShippingAddressId;
  }

  public String getDefaultBillingAddressId() {
    return defaultBillingAddressId;
  }

  public void setDefaultBillingAddressId(String defaultBillingAddressId) {
    this.defaultBillingAddressId = defaultBillingAddressId;
  }

  public List<String> getShippingAddressIds() {
    return shippingAddressIds;
  }

  public void setShippingAddressIds(List<String> shippingAddressIds) {
    this.shippingAddressIds = shippingAddressIds;
  }

  public List<String> getBillingAddressIds() {
    return billingAddressIds;
  }

  public void setBillingAddressIds(List<String> billingAddressIds) {
    this.billingAddressIds = billingAddressIds;
  }

  public Boolean getIsEmailVerified() {
    return isEmailVerified;
  }

  public void setIsEmailVerified(Boolean isEmailVerified) {
    this.isEmailVerified = isEmailVerified;
  }

  public Reference getCustomerGroupRef() {
    return customerGroupRef;
  }

  public void setCustomerGroupRef(Reference customerGroupRef) {
    this.customerGroupRef = customerGroupRef;
  }

  public String getExternalId() {
    return externalId;
  }

  public void setExternalId(String externalId) {
    this.externalId = externalId;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public AuthenticationMode getAuthenticationMode() {
    return authenticationMode;
  }

  public void setAuthenticationMode(AuthenticationMode authenticationMode) {
    this.authenticationMode = authenticationMode;
  }

  public String getFirstName() {
    return firstName;
  }

  public void setFirstName(String firstName) {
    this.firstName = firstName;
  }

  public String getLastName() {
    return lastName;
  }

  public void setLastName(String lastName) {
    this.lastName = lastName;
  }

  public String getMiddleName() {
    return middleName;
  }

  public void setMiddleName(String middleName) {
    this.middleName = middleName;
  }

  public String getTitle() {
    return title;
  }

  public void setTitle(String title) {
    this.title = title;
  }

  public String getLocale() {
    return locale;
  }

  public void setLocale(String locale) {
    this.locale = locale;
  }

  public String getSalutation() {
    return salutation;
  }

  public void setSalutation(String salutation) {
    this.salutation = salutation;
  }

  public LocalDate getDateOfBirth() {
    return dateOfBirth;
  }

  public void setDateOfBirth(LocalDate dateOfBirth) {
    this.dateOfBirth = dateOfBirth;
  }

  public String getCompanyName() {
    return companyName;
  }

  public void setCompanyName(String companyName) {
    this.companyName = companyName;
  }

  public String getVatId() {
    return vatId;
  }

  public void setVatId(String vatId) {
    this.vatId = vatId;
  }

  public String getPassword() {
    return password;
  }

  public void setPassword(String password) {
    this.password = password;
  }

  public CustomerGroup getCustomerGroup() {
    return customerGroup;
  }

  public void setCustomerGroup(CustomerGroup customerGroup) {
    this.customerGroup = customerGroup;
  }

  public Address getDefaultShippingAddress() {
    return defaultShippingAddress;
  }

  public void setDefaultShippingAddress(Address defaultShippingAddress) {
    this.defaultShippingAddress = defaultShippingAddress;
  }

  public Address getDefaultBillingAddress() {
    return defaultBillingAddress;
  }

  public void setDefaultBillingAddress(Address defaultBillingAddress) {
    this.defaultBillingAddress = defaultBillingAddress;
  }

  public List<Address> getShippingAddresses() {
    return shippingAddresses;
  }

  public void setShippingAddresses(List<Address> shippingAddresses) {
    this.shippingAddresses = shippingAddresses;
  }

  public List<Address> getBillingAddresses() {
    return billingAddresses;
  }

  public void setBillingAddresses(List<Address> billingAddresses) {
    this.billingAddresses = billingAddresses;
  }

  public List<KeyReference> getStoresRef() {
    return storesRef;
  }

  public void setStoresRef(List<KeyReference> storesRef) {
    this.storesRef = storesRef;
  }

  public List<Store> getStores() {
    return stores;
  }

  public void setStores(List<Store> stores) {
    this.stores = stores;
  }

  /**
   * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
   */
  public List<CustomerGroupAssignment> getCustomerGroupAssignments() {
    return customerGroupAssignments;
  }

  public void setCustomerGroupAssignments(List<CustomerGroupAssignment> customerGroupAssignments) {
    this.customerGroupAssignments = customerGroupAssignments;
  }

  public CustomFieldsType getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsType custom) {
    this.custom = custom;
  }

  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public Long getVersion() {
    return version;
  }

  public void setVersion(Long version) {
    this.version = version;
  }

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }

  public OffsetDateTime getLastModifiedAt() {
    return lastModifiedAt;
  }

  public void setLastModifiedAt(OffsetDateTime lastModifiedAt) {
    this.lastModifiedAt = lastModifiedAt;
  }

  public Initiator getCreatedBy() {
    return createdBy;
  }

  public void setCreatedBy(Initiator createdBy) {
    this.createdBy = createdBy;
  }

  public Initiator getLastModifiedBy() {
    return lastModifiedBy;
  }

  public void setLastModifiedBy(Initiator lastModifiedBy) {
    this.lastModifiedBy = lastModifiedBy;
  }

  @Override
  public String toString() {
    return "Customer{customerNumber='" + customerNumber + "', email='" + email + "', addresses='" + addresses + "', defaultShippingAddressId='" + defaultShippingAddressId + "', defaultBillingAddressId='" + defaultBillingAddressId + "', shippingAddressIds='" + shippingAddressIds + "', billingAddressIds='" + billingAddressIds + "', isEmailVerified='" + isEmailVerified + "', customerGroupRef='" + customerGroupRef + "', externalId='" + externalId + "', key='" + key + "', authenticationMode='" + authenticationMode + "', firstName='" + firstName + "', lastName='" + lastName + "', middleName='" + middleName + "', title='" + title + "', locale='" + locale + "', salutation='" + salutation + "', dateOfBirth='" + dateOfBirth + "', companyName='" + companyName + "', vatId='" + vatId + "', password='" + password + "', customerGroup='" + customerGroup + "', defaultShippingAddress='" + defaultShippingAddress + "', defaultBillingAddress='" + defaultBillingAddress + "', shippingAddresses='" + shippingAddresses + "', billingAddresses='" + billingAddresses + "', storesRef='" + storesRef + "', stores='" + stores + "', customerGroupAssignments='" + customerGroupAssignments + "', custom='" + custom + "', id='" + id + "', version='" + version + "', createdAt='" + createdAt + "', lastModifiedAt='" + lastModifiedAt + "', createdBy='" + createdBy + "', lastModifiedBy='" + lastModifiedBy + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Customer that = (Customer) o;
    return Objects.equals(customerNumber, that.customerNumber) &&
        Objects.equals(email, that.email) &&
        Objects.equals(addresses, that.addresses) &&
        Objects.equals(defaultShippingAddressId, that.defaultShippingAddressId) &&
        Objects.equals(defaultBillingAddressId, that.defaultBillingAddressId) &&
        Objects.equals(shippingAddressIds, that.shippingAddressIds) &&
        Objects.equals(billingAddressIds, that.billingAddressIds) &&
        Objects.equals(isEmailVerified, that.isEmailVerified) &&
        Objects.equals(customerGroupRef, that.customerGroupRef) &&
        Objects.equals(externalId, that.externalId) &&
        Objects.equals(key, that.key) &&
        Objects.equals(authenticationMode, that.authenticationMode) &&
        Objects.equals(firstName, that.firstName) &&
        Objects.equals(lastName, that.lastName) &&
        Objects.equals(middleName, that.middleName) &&
        Objects.equals(title, that.title) &&
        Objects.equals(locale, that.locale) &&
        Objects.equals(salutation, that.salutation) &&
        Objects.equals(dateOfBirth, that.dateOfBirth) &&
        Objects.equals(companyName, that.companyName) &&
        Objects.equals(vatId, that.vatId) &&
        Objects.equals(password, that.password) &&
        Objects.equals(customerGroup, that.customerGroup) &&
        Objects.equals(defaultShippingAddress, that.defaultShippingAddress) &&
        Objects.equals(defaultBillingAddress, that.defaultBillingAddress) &&
        Objects.equals(shippingAddresses, that.shippingAddresses) &&
        Objects.equals(billingAddresses, that.billingAddresses) &&
        Objects.equals(storesRef, that.storesRef) &&
        Objects.equals(stores, that.stores) &&
        Objects.equals(customerGroupAssignments, that.customerGroupAssignments) &&
        Objects.equals(custom, that.custom) &&
        Objects.equals(id, that.id) &&
        Objects.equals(version, that.version) &&
        Objects.equals(createdAt, that.createdAt) &&
        Objects.equals(lastModifiedAt, that.lastModifiedAt) &&
        Objects.equals(createdBy, that.createdBy) &&
        Objects.equals(lastModifiedBy, that.lastModifiedBy);
  }

  @Override
  public int hashCode() {
    return Objects.hash(customerNumber, email, addresses, defaultShippingAddressId, defaultBillingAddressId, shippingAddressIds, billingAddressIds, isEmailVerified, customerGroupRef, externalId, key, authenticationMode, firstName, lastName, middleName, title, locale, salutation, dateOfBirth, companyName, vatId, password, customerGroup, defaultShippingAddress, defaultBillingAddress, shippingAddresses, billingAddresses, storesRef, stores, customerGroupAssignments, custom, id, version, createdAt, lastModifiedAt, createdBy, lastModifiedBy);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String customerNumber;

    private String email;

    private List<Address> addresses;

    private String defaultShippingAddressId;

    private String defaultBillingAddressId;

    private List<String> shippingAddressIds;

    private List<String> billingAddressIds;

    private Boolean isEmailVerified;

    private Reference customerGroupRef;

    private String externalId;

    private String key;

    private AuthenticationMode authenticationMode;

    private String firstName;

    private String lastName;

    private String middleName;

    private String title;

    private String locale;

    private String salutation;

    private LocalDate dateOfBirth;

    private String companyName;

    private String vatId;

    private String password;

    private CustomerGroup customerGroup;

    private Address defaultShippingAddress;

    private Address defaultBillingAddress;

    private List<Address> shippingAddresses;

    private List<Address> billingAddresses;

    private List<KeyReference> storesRef;

    private List<Store> stores;

    /**
     * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
     */
    private List<CustomerGroupAssignment> customerGroupAssignments;

    private CustomFieldsType custom;

    private String id;

    private Long version;

    private OffsetDateTime createdAt;

    private OffsetDateTime lastModifiedAt;

    private Initiator createdBy;

    private Initiator lastModifiedBy;

    public Customer build() {
      Customer result = new Customer();
      result.customerNumber = this.customerNumber;
      result.email = this.email;
      result.addresses = this.addresses;
      result.defaultShippingAddressId = this.defaultShippingAddressId;
      result.defaultBillingAddressId = this.defaultBillingAddressId;
      result.shippingAddressIds = this.shippingAddressIds;
      result.billingAddressIds = this.billingAddressIds;
      result.isEmailVerified = this.isEmailVerified;
      result.customerGroupRef = this.customerGroupRef;
      result.externalId = this.externalId;
      result.key = this.key;
      result.authenticationMode = this.authenticationMode;
      result.firstName = this.firstName;
      result.lastName = this.lastName;
      result.middleName = this.middleName;
      result.title = this.title;
      result.locale = this.locale;
      result.salutation = this.salutation;
      result.dateOfBirth = this.dateOfBirth;
      result.companyName = this.companyName;
      result.vatId = this.vatId;
      result.password = this.password;
      result.customerGroup = this.customerGroup;
      result.defaultShippingAddress = this.defaultShippingAddress;
      result.defaultBillingAddress = this.defaultBillingAddress;
      result.shippingAddresses = this.shippingAddresses;
      result.billingAddresses = this.billingAddresses;
      result.storesRef = this.storesRef;
      result.stores = this.stores;
      result.customerGroupAssignments = this.customerGroupAssignments;
      result.custom = this.custom;
      result.id = this.id;
      result.version = this.version;
      result.createdAt = this.createdAt;
      result.lastModifiedAt = this.lastModifiedAt;
      result.createdBy = this.createdBy;
      result.lastModifiedBy = this.lastModifiedBy;
      return result;
    }

    public Builder customerNumber(String customerNumber) {
      this.customerNumber = customerNumber;
      return this;
    }

    public Builder email(String email) {
      this.email = email;
      return this;
    }

    public Builder addresses(List<Address> addresses) {
      this.addresses = addresses;
      return this;
    }

    public Builder defaultShippingAddressId(String defaultShippingAddressId) {
      this.defaultShippingAddressId = defaultShippingAddressId;
      return this;
    }

    public Builder defaultBillingAddressId(String defaultBillingAddressId) {
      this.defaultBillingAddressId = defaultBillingAddressId;
      return this;
    }

    public Builder shippingAddressIds(List<String> shippingAddressIds) {
      this.shippingAddressIds = shippingAddressIds;
      return this;
    }

    public Builder billingAddressIds(List<String> billingAddressIds) {
      this.billingAddressIds = billingAddressIds;
      return this;
    }

    public Builder isEmailVerified(Boolean isEmailVerified) {
      this.isEmailVerified = isEmailVerified;
      return this;
    }

    public Builder customerGroupRef(Reference customerGroupRef) {
      this.customerGroupRef = customerGroupRef;
      return this;
    }

    public Builder externalId(String externalId) {
      this.externalId = externalId;
      return this;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder authenticationMode(AuthenticationMode authenticationMode) {
      this.authenticationMode = authenticationMode;
      return this;
    }

    public Builder firstName(String firstName) {
      this.firstName = firstName;
      return this;
    }

    public Builder lastName(String lastName) {
      this.lastName = lastName;
      return this;
    }

    public Builder middleName(String middleName) {
      this.middleName = middleName;
      return this;
    }

    public Builder title(String title) {
      this.title = title;
      return this;
    }

    public Builder locale(String locale) {
      this.locale = locale;
      return this;
    }

    public Builder salutation(String salutation) {
      this.salutation = salutation;
      return this;
    }

    public Builder dateOfBirth(LocalDate dateOfBirth) {
      this.dateOfBirth = dateOfBirth;
      return this;
    }

    public Builder companyName(String companyName) {
      this.companyName = companyName;
      return this;
    }

    public Builder vatId(String vatId) {
      this.vatId = vatId;
      return this;
    }

    public Builder password(String password) {
      this.password = password;
      return this;
    }

    public Builder customerGroup(CustomerGroup customerGroup) {
      this.customerGroup = customerGroup;
      return this;
    }

    public Builder defaultShippingAddress(Address defaultShippingAddress) {
      this.defaultShippingAddress = defaultShippingAddress;
      return this;
    }

    public Builder defaultBillingAddress(Address defaultBillingAddress) {
      this.defaultBillingAddress = defaultBillingAddress;
      return this;
    }

    public Builder shippingAddresses(List<Address> shippingAddresses) {
      this.shippingAddresses = shippingAddresses;
      return this;
    }

    public Builder billingAddresses(List<Address> billingAddresses) {
      this.billingAddresses = billingAddresses;
      return this;
    }

    public Builder storesRef(List<KeyReference> storesRef) {
      this.storesRef = storesRef;
      return this;
    }

    public Builder stores(List<Store> stores) {
      this.stores = stores;
      return this;
    }

    /**
     * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
     */
    public Builder customerGroupAssignments(
        List<CustomerGroupAssignment> customerGroupAssignments) {
      this.customerGroupAssignments = customerGroupAssignments;
      return this;
    }

    public Builder custom(CustomFieldsType custom) {
      this.custom = custom;
      return this;
    }

    public Builder id(String id) {
      this.id = id;
      return this;
    }

    public Builder version(Long version) {
      this.version = version;
      return this;
    }

    public Builder createdAt(OffsetDateTime createdAt) {
      this.createdAt = createdAt;
      return this;
    }

    public Builder lastModifiedAt(OffsetDateTime lastModifiedAt) {
      this.lastModifiedAt = lastModifiedAt;
      return this;
    }

    public Builder createdBy(Initiator createdBy) {
      this.createdBy = createdBy;
      return this;
    }

    public Builder lastModifiedBy(Initiator lastModifiedBy) {
      this.lastModifiedBy = lastModifiedBy;
      return this;
    }
  }
}
