package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;

/**
 * A field to access a customer's active cart.
 */
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    include = JsonTypeInfo.As.PROPERTY,
    property = "__typename"
)
@JsonSubTypes(@JsonSubTypes.Type(value = InStore.class, name = "InStore"))
public interface CustomerActiveCartInterface {
  Cart getCustomerActiveCart();

  void setCustomerActiveCart(Cart customerActiveCart);
}
