package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class CustomerCompanyNameSet implements com.commercetools.graphql.api.types.MessagePayload {
  private String companyName;

  private String type;

  public CustomerCompanyNameSet() {
  }

  public CustomerCompanyNameSet(String companyName, String type) {
    this.companyName = companyName;
    this.type = type;
  }

  public String getCompanyName() {
    return companyName;
  }

  public void setCompanyName(String companyName) {
    this.companyName = companyName;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "CustomerCompanyNameSet{companyName='" + companyName + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CustomerCompanyNameSet that = (CustomerCompanyNameSet) o;
    return Objects.equals(companyName, that.companyName) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(companyName, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String companyName;

    private String type;

    public CustomerCompanyNameSet build() {
      CustomerCompanyNameSet result = new CustomerCompanyNameSet();
      result.companyName = this.companyName;
      result.type = this.type;
      return result;
    }

    public Builder companyName(String companyName) {
      this.companyName = companyName;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
