package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class CustomerCreated implements com.commercetools.graphql.api.types.MessagePayload {
  private Customer customer;

  private String type;

  public CustomerCreated() {
  }

  public CustomerCreated(Customer customer, String type) {
    this.customer = customer;
    this.type = type;
  }

  public Customer getCustomer() {
    return customer;
  }

  public void setCustomer(Customer customer) {
    this.customer = customer;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "CustomerCreated{customer='" + customer + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CustomerCreated that = (CustomerCreated) o;
    return Objects.equals(customer, that.customer) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(customer, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Customer customer;

    private String type;

    public CustomerCreated build() {
      CustomerCreated result = new CustomerCreated();
      result.customer = this.customer;
      result.type = this.type;
      return result;
    }

    public Builder customer(Customer customer) {
      this.customer = customer;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
