package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class CustomerCustomTypeSet implements com.commercetools.graphql.api.types.MessagePayload {
  private CustomFieldsType customFields;

  private String previousTypeId;

  private String type;

  public CustomerCustomTypeSet() {
  }

  public CustomerCustomTypeSet(CustomFieldsType customFields, String previousTypeId, String type) {
    this.customFields = customFields;
    this.previousTypeId = previousTypeId;
    this.type = type;
  }

  public CustomFieldsType getCustomFields() {
    return customFields;
  }

  public void setCustomFields(CustomFieldsType customFields) {
    this.customFields = customFields;
  }

  public String getPreviousTypeId() {
    return previousTypeId;
  }

  public void setPreviousTypeId(String previousTypeId) {
    this.previousTypeId = previousTypeId;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "CustomerCustomTypeSet{customFields='" + customFields + "', previousTypeId='" + previousTypeId + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CustomerCustomTypeSet that = (CustomerCustomTypeSet) o;
    return Objects.equals(customFields, that.customFields) &&
        Objects.equals(previousTypeId, that.previousTypeId) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(customFields, previousTypeId, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private CustomFieldsType customFields;

    private String previousTypeId;

    private String type;

    public CustomerCustomTypeSet build() {
      CustomerCustomTypeSet result = new CustomerCustomTypeSet();
      result.customFields = this.customFields;
      result.previousTypeId = this.previousTypeId;
      result.type = this.type;
      return result;
    }

    public Builder customFields(CustomFieldsType customFields) {
      this.customFields = customFields;
      return this;
    }

    public Builder previousTypeId(String previousTypeId) {
      this.previousTypeId = previousTypeId;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
