package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class CustomerEmailVerified implements com.commercetools.graphql.api.types.MessagePayload {
  private String type;

  public CustomerEmailVerified() {
  }

  public CustomerEmailVerified(String type) {
    this.type = type;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "CustomerEmailVerified{type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CustomerEmailVerified that = (CustomerEmailVerified) o;
    return Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    public CustomerEmailVerified build() {
      CustomerEmailVerified result = new CustomerEmailVerified();
      result.type = this.type;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
