package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class CustomerFirstNameSet implements com.commercetools.graphql.api.types.MessagePayload {
  private String firstName;

  private String type;

  public CustomerFirstNameSet() {
  }

  public CustomerFirstNameSet(String firstName, String type) {
    this.firstName = firstName;
    this.type = type;
  }

  public String getFirstName() {
    return firstName;
  }

  public void setFirstName(String firstName) {
    this.firstName = firstName;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "CustomerFirstNameSet{firstName='" + firstName + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CustomerFirstNameSet that = (CustomerFirstNameSet) o;
    return Objects.equals(firstName, that.firstName) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(firstName, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String firstName;

    private String type;

    public CustomerFirstNameSet build() {
      CustomerFirstNameSet result = new CustomerFirstNameSet();
      result.firstName = this.firstName;
      result.type = this.type;
      return result;
    }

    public Builder firstName(String firstName) {
      this.firstName = firstName;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
