package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

/**
 * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
 */
public class CustomerGroupAssignment {
  private Reference customerGroupRef;

  private CustomerGroup customerGroup;

  public CustomerGroupAssignment() {
  }

  public CustomerGroupAssignment(Reference customerGroupRef, CustomerGroup customerGroup) {
    this.customerGroupRef = customerGroupRef;
    this.customerGroup = customerGroup;
  }

  public Reference getCustomerGroupRef() {
    return customerGroupRef;
  }

  public void setCustomerGroupRef(Reference customerGroupRef) {
    this.customerGroupRef = customerGroupRef;
  }

  public CustomerGroup getCustomerGroup() {
    return customerGroup;
  }

  public void setCustomerGroup(CustomerGroup customerGroup) {
    this.customerGroup = customerGroup;
  }

  @Override
  public String toString() {
    return "CustomerGroupAssignment{customerGroupRef='" + customerGroupRef + "', customerGroup='" + customerGroup + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CustomerGroupAssignment that = (CustomerGroupAssignment) o;
    return Objects.equals(customerGroupRef, that.customerGroupRef) &&
        Objects.equals(customerGroup, that.customerGroup);
  }

  @Override
  public int hashCode() {
    return Objects.hash(customerGroupRef, customerGroup);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Reference customerGroupRef;

    private CustomerGroup customerGroup;

    public CustomerGroupAssignment build() {
      CustomerGroupAssignment result = new CustomerGroupAssignment();
      result.customerGroupRef = this.customerGroupRef;
      result.customerGroup = this.customerGroup;
      return result;
    }

    public Builder customerGroupRef(Reference customerGroupRef) {
      this.customerGroupRef = customerGroupRef;
      return this;
    }

    public Builder customerGroup(CustomerGroup customerGroup) {
      this.customerGroup = customerGroup;
      return this;
    }
  }
}
