package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class CustomerGroupDraft {
  private String groupName;

  private String key;

  private CustomFieldsDraft custom;

  public CustomerGroupDraft() {
  }

  public CustomerGroupDraft(String groupName, String key, CustomFieldsDraft custom) {
    this.groupName = groupName;
    this.key = key;
    this.custom = custom;
  }

  public String getGroupName() {
    return groupName;
  }

  public void setGroupName(String groupName) {
    this.groupName = groupName;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public CustomFieldsDraft getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsDraft custom) {
    this.custom = custom;
  }

  @Override
  public String toString() {
    return "CustomerGroupDraft{groupName='" + groupName + "', key='" + key + "', custom='" + custom + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CustomerGroupDraft that = (CustomerGroupDraft) o;
    return Objects.equals(groupName, that.groupName) &&
        Objects.equals(key, that.key) &&
        Objects.equals(custom, that.custom);
  }

  @Override
  public int hashCode() {
    return Objects.hash(groupName, key, custom);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String groupName;

    private String key;

    private CustomFieldsDraft custom;

    public CustomerGroupDraft build() {
      CustomerGroupDraft result = new CustomerGroupDraft();
      result.groupName = this.groupName;
      result.key = this.key;
      result.custom = this.custom;
      return result;
    }

    public Builder groupName(String groupName) {
      this.groupName = groupName;
      return this;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder custom(CustomFieldsDraft custom) {
      this.custom = custom;
      return this;
    }
  }
}
