package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class CustomerGroupLimitsProjection {
  private CustomerGroupLimitWithCurrent total;

  public CustomerGroupLimitsProjection() {
  }

  public CustomerGroupLimitsProjection(CustomerGroupLimitWithCurrent total) {
    this.total = total;
  }

  public CustomerGroupLimitWithCurrent getTotal() {
    return total;
  }

  public void setTotal(CustomerGroupLimitWithCurrent total) {
    this.total = total;
  }

  @Override
  public String toString() {
    return "CustomerGroupLimitsProjection{total='" + total + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CustomerGroupLimitsProjection that = (CustomerGroupLimitsProjection) o;
    return Objects.equals(total, that.total);
  }

  @Override
  public int hashCode() {
    return Objects.hash(total);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private CustomerGroupLimitWithCurrent total;

    public CustomerGroupLimitsProjection build() {
      CustomerGroupLimitsProjection result = new CustomerGroupLimitsProjection();
      result.total = this.total;
      return result;
    }

    public Builder total(CustomerGroupLimitWithCurrent total) {
      this.total = total;
      return this;
    }
  }
}
