package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class CustomerGroupReferenceIdentifier {
  private String typeId;

  private String id;

  private String key;

  public CustomerGroupReferenceIdentifier() {
  }

  public CustomerGroupReferenceIdentifier(String typeId, String id, String key) {
    this.typeId = typeId;
    this.id = id;
    this.key = key;
  }

  public String getTypeId() {
    return typeId;
  }

  public void setTypeId(String typeId) {
    this.typeId = typeId;
  }

  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  @Override
  public String toString() {
    return "CustomerGroupReferenceIdentifier{typeId='" + typeId + "', id='" + id + "', key='" + key + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CustomerGroupReferenceIdentifier that = (CustomerGroupReferenceIdentifier) o;
    return Objects.equals(typeId, that.typeId) &&
        Objects.equals(id, that.id) &&
        Objects.equals(key, that.key);
  }

  @Override
  public int hashCode() {
    return Objects.hash(typeId, id, key);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String typeId;

    private String id;

    private String key;

    public CustomerGroupReferenceIdentifier build() {
      CustomerGroupReferenceIdentifier result = new CustomerGroupReferenceIdentifier();
      result.typeId = this.typeId;
      result.id = this.id;
      result.key = this.key;
      return result;
    }

    public Builder typeId(String typeId) {
      this.typeId = typeId;
      return this;
    }

    public Builder id(String id) {
      this.id = id;
      return this;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }
  }
}
