package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class CustomerGroupSet implements com.commercetools.graphql.api.types.MessagePayload {
  private CustomerGroup customerGroup;

  private Reference customerGroupRef;

  private String type;

  public CustomerGroupSet() {
  }

  public CustomerGroupSet(CustomerGroup customerGroup, Reference customerGroupRef, String type) {
    this.customerGroup = customerGroup;
    this.customerGroupRef = customerGroupRef;
    this.type = type;
  }

  public CustomerGroup getCustomerGroup() {
    return customerGroup;
  }

  public void setCustomerGroup(CustomerGroup customerGroup) {
    this.customerGroup = customerGroup;
  }

  public Reference getCustomerGroupRef() {
    return customerGroupRef;
  }

  public void setCustomerGroupRef(Reference customerGroupRef) {
    this.customerGroupRef = customerGroupRef;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "CustomerGroupSet{customerGroup='" + customerGroup + "', customerGroupRef='" + customerGroupRef + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CustomerGroupSet that = (CustomerGroupSet) o;
    return Objects.equals(customerGroup, that.customerGroup) &&
        Objects.equals(customerGroupRef, that.customerGroupRef) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(customerGroup, customerGroupRef, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private CustomerGroup customerGroup;

    private Reference customerGroupRef;

    private String type;

    public CustomerGroupSet build() {
      CustomerGroupSet result = new CustomerGroupSet();
      result.customerGroup = this.customerGroup;
      result.customerGroupRef = this.customerGroupRef;
      result.type = this.type;
      return result;
    }

    public Builder customerGroup(CustomerGroup customerGroup) {
      this.customerGroup = customerGroup;
      return this;
    }

    public Builder customerGroupRef(Reference customerGroupRef) {
      this.customerGroupRef = customerGroupRef;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
