package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class CustomerLimitsProjection {
  private CustomerLimitWithCurrent total;

  public CustomerLimitsProjection() {
  }

  public CustomerLimitsProjection(CustomerLimitWithCurrent total) {
    this.total = total;
  }

  public CustomerLimitWithCurrent getTotal() {
    return total;
  }

  public void setTotal(CustomerLimitWithCurrent total) {
    this.total = total;
  }

  @Override
  public String toString() {
    return "CustomerLimitsProjection{total='" + total + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CustomerLimitsProjection that = (CustomerLimitsProjection) o;
    return Objects.equals(total, that.total);
  }

  @Override
  public int hashCode() {
    return Objects.hash(total);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private CustomerLimitWithCurrent total;

    public CustomerLimitsProjection build() {
      CustomerLimitsProjection result = new CustomerLimitsProjection();
      result.total = this.total;
      return result;
    }

    public Builder total(CustomerLimitWithCurrent total) {
      this.total = total;
      return this;
    }
  }
}
