package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class CustomerPasswordTokenCreated implements com.commercetools.graphql.api.types.MessagePayload {
  private String customerId;

  private OffsetDateTime expiresAt;

  private String type;

  public CustomerPasswordTokenCreated() {
  }

  public CustomerPasswordTokenCreated(String customerId, OffsetDateTime expiresAt, String type) {
    this.customerId = customerId;
    this.expiresAt = expiresAt;
    this.type = type;
  }

  public String getCustomerId() {
    return customerId;
  }

  public void setCustomerId(String customerId) {
    this.customerId = customerId;
  }

  public OffsetDateTime getExpiresAt() {
    return expiresAt;
  }

  public void setExpiresAt(OffsetDateTime expiresAt) {
    this.expiresAt = expiresAt;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "CustomerPasswordTokenCreated{customerId='" + customerId + "', expiresAt='" + expiresAt + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CustomerPasswordTokenCreated that = (CustomerPasswordTokenCreated) o;
    return Objects.equals(customerId, that.customerId) &&
        Objects.equals(expiresAt, that.expiresAt) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(customerId, expiresAt, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String customerId;

    private OffsetDateTime expiresAt;

    private String type;

    public CustomerPasswordTokenCreated build() {
      CustomerPasswordTokenCreated result = new CustomerPasswordTokenCreated();
      result.customerId = this.customerId;
      result.expiresAt = this.expiresAt;
      result.type = this.type;
      return result;
    }

    public Builder customerId(String customerId) {
      this.customerId = customerId;
      return this;
    }

    public Builder expiresAt(OffsetDateTime expiresAt) {
      this.expiresAt = expiresAt;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
