package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class CustomerPasswordUpdated implements com.commercetools.graphql.api.types.MessagePayload {
  private Boolean reset;

  private String type;

  public CustomerPasswordUpdated() {
  }

  public CustomerPasswordUpdated(Boolean reset, String type) {
    this.reset = reset;
    this.type = type;
  }

  public Boolean getReset() {
    return reset;
  }

  public void setReset(Boolean reset) {
    this.reset = reset;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "CustomerPasswordUpdated{reset='" + reset + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CustomerPasswordUpdated that = (CustomerPasswordUpdated) o;
    return Objects.equals(reset, that.reset) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(reset, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Boolean reset;

    private String type;

    public CustomerPasswordUpdated build() {
      CustomerPasswordUpdated result = new CustomerPasswordUpdated();
      result.reset = this.reset;
      result.type = this.type;
      return result;
    }

    public Builder reset(Boolean reset) {
      this.reset = reset;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
