package com.commercetools.graphql.api.types;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class CustomerSignMeUpDraft {
  private String email;

  private String password;

  private String firstName;

  private String lastName;

  private String middleName;

  private String title;

  private LocalDate dateOfBirth;

  private String companyName;

  private String vatId;

  private List<AddressInput> addresses = Collections.emptyList();

  /**
   * The index of the address in the `addresses` list. The `defaultBillingAddressId` of the customer will be set to the ID of that address.
   */
  private Integer defaultBillingAddress;

  /**
   * The index of the address in the `addresses` list. The `defaultShippingAddressId` of the customer will be set to the ID of that address.
   */
  private Integer defaultShippingAddress;

  /**
   * The indices of the shipping addresses in the `addresses` list. The `shippingAddressIds` of the `Customer` will be set to the IDs of that addresses.
   */
  private List<Integer> shippingAddresses = Collections.emptyList();

  /**
   * The indices of the billing addresses in the `addresses` list. The `billingAddressIds` of the customer will be set to the IDs of that addresses.
   */
  private List<Integer> billingAddresses = Collections.emptyList();

  private CustomFieldsDraft custom;

  private String locale;

  private String salutation;

  private String key;

  private List<ResourceIdentifierInput> stores;

  public CustomerSignMeUpDraft() {
  }

  public CustomerSignMeUpDraft(String email, String password, String firstName, String lastName,
      String middleName, String title, LocalDate dateOfBirth, String companyName, String vatId,
      List<AddressInput> addresses, Integer defaultBillingAddress, Integer defaultShippingAddress,
      List<Integer> shippingAddresses, List<Integer> billingAddresses, CustomFieldsDraft custom,
      String locale, String salutation, String key, List<ResourceIdentifierInput> stores) {
    this.email = email;
    this.password = password;
    this.firstName = firstName;
    this.lastName = lastName;
    this.middleName = middleName;
    this.title = title;
    this.dateOfBirth = dateOfBirth;
    this.companyName = companyName;
    this.vatId = vatId;
    this.addresses = addresses;
    this.defaultBillingAddress = defaultBillingAddress;
    this.defaultShippingAddress = defaultShippingAddress;
    this.shippingAddresses = shippingAddresses;
    this.billingAddresses = billingAddresses;
    this.custom = custom;
    this.locale = locale;
    this.salutation = salutation;
    this.key = key;
    this.stores = stores;
  }

  public String getEmail() {
    return email;
  }

  public void setEmail(String email) {
    this.email = email;
  }

  public String getPassword() {
    return password;
  }

  public void setPassword(String password) {
    this.password = password;
  }

  public String getFirstName() {
    return firstName;
  }

  public void setFirstName(String firstName) {
    this.firstName = firstName;
  }

  public String getLastName() {
    return lastName;
  }

  public void setLastName(String lastName) {
    this.lastName = lastName;
  }

  public String getMiddleName() {
    return middleName;
  }

  public void setMiddleName(String middleName) {
    this.middleName = middleName;
  }

  public String getTitle() {
    return title;
  }

  public void setTitle(String title) {
    this.title = title;
  }

  public LocalDate getDateOfBirth() {
    return dateOfBirth;
  }

  public void setDateOfBirth(LocalDate dateOfBirth) {
    this.dateOfBirth = dateOfBirth;
  }

  public String getCompanyName() {
    return companyName;
  }

  public void setCompanyName(String companyName) {
    this.companyName = companyName;
  }

  public String getVatId() {
    return vatId;
  }

  public void setVatId(String vatId) {
    this.vatId = vatId;
  }

  public List<AddressInput> getAddresses() {
    return addresses;
  }

  public void setAddresses(List<AddressInput> addresses) {
    this.addresses = addresses;
  }

  /**
   * The index of the address in the `addresses` list. The `defaultBillingAddressId` of the customer will be set to the ID of that address.
   */
  public Integer getDefaultBillingAddress() {
    return defaultBillingAddress;
  }

  public void setDefaultBillingAddress(Integer defaultBillingAddress) {
    this.defaultBillingAddress = defaultBillingAddress;
  }

  /**
   * The index of the address in the `addresses` list. The `defaultShippingAddressId` of the customer will be set to the ID of that address.
   */
  public Integer getDefaultShippingAddress() {
    return defaultShippingAddress;
  }

  public void setDefaultShippingAddress(Integer defaultShippingAddress) {
    this.defaultShippingAddress = defaultShippingAddress;
  }

  /**
   * The indices of the shipping addresses in the `addresses` list. The `shippingAddressIds` of the `Customer` will be set to the IDs of that addresses.
   */
  public List<Integer> getShippingAddresses() {
    return shippingAddresses;
  }

  public void setShippingAddresses(List<Integer> shippingAddresses) {
    this.shippingAddresses = shippingAddresses;
  }

  /**
   * The indices of the billing addresses in the `addresses` list. The `billingAddressIds` of the customer will be set to the IDs of that addresses.
   */
  public List<Integer> getBillingAddresses() {
    return billingAddresses;
  }

  public void setBillingAddresses(List<Integer> billingAddresses) {
    this.billingAddresses = billingAddresses;
  }

  public CustomFieldsDraft getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsDraft custom) {
    this.custom = custom;
  }

  public String getLocale() {
    return locale;
  }

  public void setLocale(String locale) {
    this.locale = locale;
  }

  public String getSalutation() {
    return salutation;
  }

  public void setSalutation(String salutation) {
    this.salutation = salutation;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public List<ResourceIdentifierInput> getStores() {
    return stores;
  }

  public void setStores(List<ResourceIdentifierInput> stores) {
    this.stores = stores;
  }

  @Override
  public String toString() {
    return "CustomerSignMeUpDraft{email='" + email + "', password='" + password + "', firstName='" + firstName + "', lastName='" + lastName + "', middleName='" + middleName + "', title='" + title + "', dateOfBirth='" + dateOfBirth + "', companyName='" + companyName + "', vatId='" + vatId + "', addresses='" + addresses + "', defaultBillingAddress='" + defaultBillingAddress + "', defaultShippingAddress='" + defaultShippingAddress + "', shippingAddresses='" + shippingAddresses + "', billingAddresses='" + billingAddresses + "', custom='" + custom + "', locale='" + locale + "', salutation='" + salutation + "', key='" + key + "', stores='" + stores + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CustomerSignMeUpDraft that = (CustomerSignMeUpDraft) o;
    return Objects.equals(email, that.email) &&
        Objects.equals(password, that.password) &&
        Objects.equals(firstName, that.firstName) &&
        Objects.equals(lastName, that.lastName) &&
        Objects.equals(middleName, that.middleName) &&
        Objects.equals(title, that.title) &&
        Objects.equals(dateOfBirth, that.dateOfBirth) &&
        Objects.equals(companyName, that.companyName) &&
        Objects.equals(vatId, that.vatId) &&
        Objects.equals(addresses, that.addresses) &&
        Objects.equals(defaultBillingAddress, that.defaultBillingAddress) &&
        Objects.equals(defaultShippingAddress, that.defaultShippingAddress) &&
        Objects.equals(shippingAddresses, that.shippingAddresses) &&
        Objects.equals(billingAddresses, that.billingAddresses) &&
        Objects.equals(custom, that.custom) &&
        Objects.equals(locale, that.locale) &&
        Objects.equals(salutation, that.salutation) &&
        Objects.equals(key, that.key) &&
        Objects.equals(stores, that.stores);
  }

  @Override
  public int hashCode() {
    return Objects.hash(email, password, firstName, lastName, middleName, title, dateOfBirth, companyName, vatId, addresses, defaultBillingAddress, defaultShippingAddress, shippingAddresses, billingAddresses, custom, locale, salutation, key, stores);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String email;

    private String password;

    private String firstName;

    private String lastName;

    private String middleName;

    private String title;

    private LocalDate dateOfBirth;

    private String companyName;

    private String vatId;

    private List<AddressInput> addresses = Collections.emptyList();

    /**
     * The index of the address in the `addresses` list. The `defaultBillingAddressId` of the customer will be set to the ID of that address.
     */
    private Integer defaultBillingAddress;

    /**
     * The index of the address in the `addresses` list. The `defaultShippingAddressId` of the customer will be set to the ID of that address.
     */
    private Integer defaultShippingAddress;

    /**
     * The indices of the shipping addresses in the `addresses` list. The `shippingAddressIds` of the `Customer` will be set to the IDs of that addresses.
     */
    private List<Integer> shippingAddresses = Collections.emptyList();

    /**
     * The indices of the billing addresses in the `addresses` list. The `billingAddressIds` of the customer will be set to the IDs of that addresses.
     */
    private List<Integer> billingAddresses = Collections.emptyList();

    private CustomFieldsDraft custom;

    private String locale;

    private String salutation;

    private String key;

    private List<ResourceIdentifierInput> stores;

    public CustomerSignMeUpDraft build() {
      CustomerSignMeUpDraft result = new CustomerSignMeUpDraft();
      result.email = this.email;
      result.password = this.password;
      result.firstName = this.firstName;
      result.lastName = this.lastName;
      result.middleName = this.middleName;
      result.title = this.title;
      result.dateOfBirth = this.dateOfBirth;
      result.companyName = this.companyName;
      result.vatId = this.vatId;
      result.addresses = this.addresses;
      result.defaultBillingAddress = this.defaultBillingAddress;
      result.defaultShippingAddress = this.defaultShippingAddress;
      result.shippingAddresses = this.shippingAddresses;
      result.billingAddresses = this.billingAddresses;
      result.custom = this.custom;
      result.locale = this.locale;
      result.salutation = this.salutation;
      result.key = this.key;
      result.stores = this.stores;
      return result;
    }

    public Builder email(String email) {
      this.email = email;
      return this;
    }

    public Builder password(String password) {
      this.password = password;
      return this;
    }

    public Builder firstName(String firstName) {
      this.firstName = firstName;
      return this;
    }

    public Builder lastName(String lastName) {
      this.lastName = lastName;
      return this;
    }

    public Builder middleName(String middleName) {
      this.middleName = middleName;
      return this;
    }

    public Builder title(String title) {
      this.title = title;
      return this;
    }

    public Builder dateOfBirth(LocalDate dateOfBirth) {
      this.dateOfBirth = dateOfBirth;
      return this;
    }

    public Builder companyName(String companyName) {
      this.companyName = companyName;
      return this;
    }

    public Builder vatId(String vatId) {
      this.vatId = vatId;
      return this;
    }

    public Builder addresses(List<AddressInput> addresses) {
      this.addresses = addresses;
      return this;
    }

    /**
     * The index of the address in the `addresses` list. The `defaultBillingAddressId` of the customer will be set to the ID of that address.
     */
    public Builder defaultBillingAddress(Integer defaultBillingAddress) {
      this.defaultBillingAddress = defaultBillingAddress;
      return this;
    }

    /**
     * The index of the address in the `addresses` list. The `defaultShippingAddressId` of the customer will be set to the ID of that address.
     */
    public Builder defaultShippingAddress(Integer defaultShippingAddress) {
      this.defaultShippingAddress = defaultShippingAddress;
      return this;
    }

    /**
     * The indices of the shipping addresses in the `addresses` list. The `shippingAddressIds` of the `Customer` will be set to the IDs of that addresses.
     */
    public Builder shippingAddresses(List<Integer> shippingAddresses) {
      this.shippingAddresses = shippingAddresses;
      return this;
    }

    /**
     * The indices of the billing addresses in the `addresses` list. The `billingAddressIds` of the customer will be set to the IDs of that addresses.
     */
    public Builder billingAddresses(List<Integer> billingAddresses) {
      this.billingAddresses = billingAddresses;
      return this;
    }

    public Builder custom(CustomFieldsDraft custom) {
      this.custom = custom;
      return this;
    }

    public Builder locale(String locale) {
      this.locale = locale;
      return this;
    }

    public Builder salutation(String salutation) {
      this.salutation = salutation;
      return this;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder stores(List<ResourceIdentifierInput> stores) {
      this.stores = stores;
      return this;
    }
  }
}
