package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.LocalDate;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class DateField implements com.commercetools.graphql.api.types.CustomField {
  private LocalDate value;

  private String name;

  public DateField() {
  }

  public DateField(LocalDate value, String name) {
    this.value = value;
    this.name = name;
  }

  public LocalDate getValue() {
    return value;
  }

  public void setValue(LocalDate value) {
    this.value = value;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  @Override
  public String toString() {
    return "DateField{value='" + value + "', name='" + name + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    DateField that = (DateField) o;
    return Objects.equals(value, that.value) &&
        Objects.equals(name, that.name);
  }

  @Override
  public int hashCode() {
    return Objects.hash(value, name);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private LocalDate value;

    private String name;

    public DateField build() {
      DateField result = new DateField();
      result.value = this.value;
      result.name = this.name;
      return result;
    }

    public Builder value(LocalDate value) {
      this.value = value;
      return this;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }
  }
}
